/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn;

import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;

public class MaxGaps
extends IntervalFunction {
    private final int maxGaps;
    private final IntervalFunction source;

    public MaxGaps(int maxGaps, IntervalFunction source) {
        this.maxGaps = maxGaps;
        this.source = Objects.requireNonNull(source);
    }

    @Override
    public IntervalsSource toIntervalSource(String field2, Analyzer analyzer) {
        return Intervals.maxgaps(this.maxGaps, this.source.toIntervalSource(field2, analyzer));
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:maxgaps(%s %s)", this.maxGaps, this.source);
    }
}

