/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredValue;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public final class DoubleField
extends Field {
    private static final FieldType FIELD_TYPE = new FieldType();
    private static final FieldType FIELD_TYPE_STORED;
    private final StoredValue storedValue;

    public DoubleField(String name, double value, Field.Store stored) {
        super(name, stored == Field.Store.YES ? FIELD_TYPE_STORED : FIELD_TYPE);
        this.fieldsData = NumericUtils.doubleToSortableLong(value);
        this.storedValue = stored == Field.Store.YES ? new StoredValue(value) : null;
    }

    @Override
    public BytesRef binaryValue() {
        byte[] encodedPoint = new byte[8];
        double value = this.getValueAsDouble();
        DoublePoint.encodeDimension(value, encodedPoint, 0);
        return new BytesRef(encodedPoint);
    }

    private double getValueAsDouble() {
        return NumericUtils.sortableLongToDouble(this.numericValue().longValue());
    }

    @Override
    public StoredValue storedValue() {
        return this.storedValue;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " <" + this.name + ":" + this.getValueAsDouble() + ">";
    }

    @Override
    public void setDoubleValue(double value) {
        super.setLongValue(NumericUtils.doubleToSortableLong(value));
        if (this.storedValue != null) {
            this.storedValue.setDoubleValue(value);
        }
    }

    @Override
    public void setLongValue(long value) {
        throw new IllegalArgumentException("cannot change value type from Double to Long");
    }

    public static Query newExactQuery(String field2, double value) {
        return DoubleField.newRangeQuery(field2, value, value);
    }

    public static Query newRangeQuery(String field2, double lowerValue, double upperValue) {
        PointRangeQuery.checkArgs(field2, lowerValue, upperValue);
        return new IndexOrDocValuesQuery(DoublePoint.newRangeQuery(field2, lowerValue, upperValue), SortedNumericDocValuesField.newSlowRangeQuery(field2, NumericUtils.doubleToSortableLong(lowerValue), NumericUtils.doubleToSortableLong(upperValue)));
    }

    public static Query newSetQuery(String field2, double ... values) {
        if (field2 == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        long[] points = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            points[i] = NumericUtils.doubleToSortableLong(values[i]);
        }
        return new IndexOrDocValuesQuery(DoublePoint.newSetQuery(field2, (double[])values.clone()), SortedNumericDocValuesField.newSlowSetQuery(field2, points));
    }

    public static SortField newSortField(String field2, boolean reverse, SortedNumericSelector.Type selector) {
        return new SortedNumericSortField(field2, SortField.Type.DOUBLE, reverse, selector);
    }

    static {
        FIELD_TYPE.setDimensions(1, 8);
        FIELD_TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        FIELD_TYPE.freeze();
        FIELD_TYPE_STORED = new FieldType(FIELD_TYPE);
        FIELD_TYPE_STORED.setStored(true);
        FIELD_TYPE_STORED.freeze();
    }
}

