/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.SpatialQuery;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.Geometry;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Line;
import org.apache.lucene.geo.Point;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

final class LatLonPointQuery
extends SpatialQuery {
    LatLonPointQuery(String field2, ShapeField.QueryRelation queryRelation, LatLonGeometry ... geometries) {
        super(field2, queryRelation, LatLonPointQuery.validateGeometry(queryRelation, geometries));
    }

    private static LatLonGeometry[] validateGeometry(ShapeField.QueryRelation queryRelation, LatLonGeometry ... geometries) {
        if (geometries != null) {
            if (queryRelation == ShapeField.QueryRelation.WITHIN) {
                for (LatLonGeometry geometry : geometries) {
                    if (!(geometry instanceof Line)) continue;
                    throw new IllegalArgumentException("LatLonPointQuery does not support " + String.valueOf((Object)ShapeField.QueryRelation.WITHIN) + " queries with line geometries");
                }
            }
            if (queryRelation == ShapeField.QueryRelation.CONTAINS) {
                for (LatLonGeometry geometry : geometries) {
                    if (geometry instanceof Point) continue;
                    throw new IllegalArgumentException("LatLonPointQuery does not support " + String.valueOf((Object)ShapeField.QueryRelation.CONTAINS) + " queries with non-points geometries");
                }
            }
        }
        return geometries;
    }

    @Override
    protected Component2D createComponent2D(Geometry ... geometries) {
        return LatLonGeometry.create((LatLonGeometry[])geometries);
    }

    @Override
    protected SpatialQuery.SpatialVisitor getSpatialVisitor() {
        final GeoEncodingUtils.Component2DPredicate component2DPredicate = GeoEncodingUtils.createComponentPredicate(this.queryComponent2D);
        final int minLat = GeoEncodingUtils.encodeLatitude(this.queryComponent2D.getMinY());
        final int maxLat = GeoEncodingUtils.encodeLatitude(this.queryComponent2D.getMaxY());
        final int minLon = GeoEncodingUtils.encodeLongitude(this.queryComponent2D.getMinX());
        final int maxLon = GeoEncodingUtils.encodeLongitude(this.queryComponent2D.getMaxX());
        return new SpatialQuery.SpatialVisitor(){

            @Override
            protected PointValues.Relation relate(byte[] minPackedValue, byte[] maxPackedValue) {
                int latLowerBound = NumericUtils.sortableBytesToInt(minPackedValue, 0);
                int latUpperBound = NumericUtils.sortableBytesToInt(maxPackedValue, 0);
                if (latLowerBound > maxLat || latUpperBound < minLat) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                int lonLowerBound = NumericUtils.sortableBytesToInt(minPackedValue, 4);
                int lonUpperBound = NumericUtils.sortableBytesToInt(maxPackedValue, 4);
                if (lonLowerBound > maxLon || lonUpperBound < minLon) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                double cellMinLat = GeoEncodingUtils.decodeLatitude(latLowerBound);
                double cellMinLon = GeoEncodingUtils.decodeLongitude(lonLowerBound);
                double cellMaxLat = GeoEncodingUtils.decodeLatitude(latUpperBound);
                double cellMaxLon = GeoEncodingUtils.decodeLongitude(lonUpperBound);
                return LatLonPointQuery.this.queryComponent2D.relate(cellMinLon, cellMaxLon, cellMinLat, cellMaxLat);
            }

            @Override
            protected Predicate<byte[]> intersects() {
                return packedValue -> component2DPredicate.test(NumericUtils.sortableBytesToInt(packedValue, 0), NumericUtils.sortableBytesToInt(packedValue, 4));
            }

            @Override
            protected Predicate<byte[]> within() {
                return packedValue -> component2DPredicate.test(NumericUtils.sortableBytesToInt(packedValue, 0), NumericUtils.sortableBytesToInt(packedValue, 4));
            }

            @Override
            protected Function<byte[], Component2D.WithinRelation> contains() {
                return packedValue -> LatLonPointQuery.this.queryComponent2D.withinPoint(GeoEncodingUtils.decodeLongitude(NumericUtils.sortableBytesToInt(packedValue, 4)), GeoEncodingUtils.decodeLatitude(NumericUtils.sortableBytesToInt(packedValue, 0)));
            }
        };
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field2)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("[");
        for (int i = 0; i < this.geometries.length; ++i) {
            sb.append(this.geometries[i].toString());
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.geometries, ((LatLonPointQuery)o).geometries);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.geometries);
        return hash;
    }
}

