/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sortedset;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;

public class DefaultSortedSetDocValuesReaderState
extends SortedSetDocValuesReaderState {
    private final String field;
    private final int valueCount;
    public final IndexReader reader;
    private final Map<String, OrdinalMap> cachedOrdMap = new HashMap<String, OrdinalMap>();
    private final FacetsConfig config;
    private final Map<String, SortedSetDocValuesReaderState.DimTree> prefixToDimTree = new HashMap<String, SortedSetDocValuesReaderState.DimTree>();
    private final Map<String, SortedSetDocValuesReaderState.OrdRange> prefixToOrdRange = new HashMap<String, SortedSetDocValuesReaderState.OrdRange>();

    public DefaultSortedSetDocValuesReaderState(IndexReader reader, FacetsConfig config) throws IOException {
        this(reader, "$facets", config);
    }

    public DefaultSortedSetDocValuesReaderState(IndexReader reader, String field2, FacetsConfig config) throws IOException {
        this.field = Objects.requireNonNull(field2);
        this.reader = Objects.requireNonNull(reader);
        this.config = Objects.requireNonNull(config);
        SortedSetDocValues dv = this.getDocValues();
        if (dv == null) {
            throw new IllegalArgumentException("field \"" + field2 + "\" was not indexed with SortedSetDocValues");
        }
        if (dv.getValueCount() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("can only handle valueCount < Integer.MAX_VALUE; got " + dv.getValueCount());
        }
        this.valueCount = (int)dv.getValueCount();
        int ord = 0;
        while (ord != this.valueCount) {
            BytesRef term = dv.lookupOrd(ord);
            String[] components = FacetsConfig.stringToPath(term.utf8ToString());
            String dim = components[0];
            if (config.getDimConfig((String)dim).hierarchical) {
                ord = this.createOneHierarchicalFacetDimState(dv, ord) + 1;
                continue;
            }
            ord = this.createOneFlatFacetDimState(dv, ord) + 1;
        }
    }

    private int createOneHierarchicalFacetDimState(SortedSetDocValues dv, int dimStartOrd) throws IOException {
        ArrayList<Boolean> hasChildren = new ArrayList<Boolean>();
        ArrayList<Integer> siblings = new ArrayList<Integer>();
        ArrayDeque<OrdAndComponent> siblingStack = new ArrayDeque<OrdAndComponent>();
        int dimEndOrd = dimStartOrd;
        BytesRef nextTerm = dv.lookupOrd(dimEndOrd);
        String[] nextComponents = FacetsConfig.stringToPath(nextTerm.utf8ToString());
        String dim = nextComponents[0];
        while (true) {
            String[] components = nextComponents;
            int ord = dimEndOrd - dimStartOrd;
            while (!siblingStack.isEmpty() && ((OrdAndComponent)siblingStack.peek()).component.length >= components.length) {
                OrdAndComponent possibleSibling = (OrdAndComponent)siblingStack.pop();
                if (possibleSibling.component.length != components.length) continue;
                siblings.set(possibleSibling.ord, ord);
            }
            if (dimEndOrd + 1 == this.valueCount) {
                siblings.add(-1);
                hasChildren.add(false);
                break;
            }
            nextTerm = dv.lookupOrd(dimEndOrd + 1);
            nextComponents = FacetsConfig.stringToPath(nextTerm.utf8ToString());
            if (!nextComponents[0].equals(components[0])) {
                siblings.add(-1);
                hasChildren.add(false);
                break;
            }
            if (components.length < nextComponents.length) {
                hasChildren.add(ord, true);
                siblingStack.push(new OrdAndComponent(ord, components));
                siblings.add(ord, -1);
            } else if (components.length == nextComponents.length) {
                siblings.add(ord, ord + 1);
                hasChildren.add(ord, false);
            } else {
                siblings.add(ord, -1);
                hasChildren.add(ord, false);
            }
            ++dimEndOrd;
        }
        this.prefixToDimTree.put(dim, new SortedSetDocValuesReaderState.DimTree(dimStartOrd, siblings, hasChildren));
        return dimEndOrd;
    }

    private int createOneFlatFacetDimState(SortedSetDocValues dv, int dimStartOrd) throws IOException {
        int dimEndOrd = dimStartOrd;
        BytesRef nextTerm = dv.lookupOrd(dimEndOrd);
        Object[] nextComponents = FacetsConfig.stringToPath(nextTerm.utf8ToString());
        if (nextComponents.length > 2) {
            throw new IllegalArgumentException("dimension not configured to handle hierarchical field; got: " + Arrays.toString(nextComponents) + " " + nextTerm.utf8ToString());
        }
        String dim = nextComponents[0];
        while (true) {
            Object[] components = nextComponents;
            if (dimEndOrd + 1 == this.valueCount || !((String)(nextComponents = FacetsConfig.stringToPath((nextTerm = dv.lookupOrd(dimEndOrd + 1)).utf8ToString()))[0]).equals(components[0])) break;
            if (nextComponents.length != 2) {
                throw new IllegalArgumentException("dimension not configured to handle hierarchical field; got: " + Arrays.toString(nextComponents) + " " + nextTerm.utf8ToString());
            }
            ++dimEndOrd;
        }
        this.prefixToOrdRange.put(dim, new SortedSetDocValuesReaderState.OrdRange(dimStartOrd, dimEndOrd));
        return dimEndOrd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long ramBytesUsed() {
        Map<String, OrdinalMap> map = this.cachedOrdMap;
        synchronized (map) {
            OrdinalMap map2 = this.cachedOrdMap.get(this.field);
            if (map2 == null) {
                return 0L;
            }
            return map2.ramBytesUsed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Accountable> getChildResources() {
        Map<String, OrdinalMap> map = this.cachedOrdMap;
        synchronized (map) {
            return Accountables.namedAccountables("DefaultSortedSetDocValuesReaderState", this.cachedOrdMap);
        }
    }

    public String toString() {
        return "DefaultSortedSetDocValuesReaderState(field=" + this.field + " reader=" + String.valueOf(this.reader) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSetDocValues getDocValues() throws IOException {
        OrdinalMap map = null;
        Map<String, OrdinalMap> map2 = this.cachedOrdMap;
        synchronized (map2) {
            map = this.cachedOrdMap.get(this.field);
            if (map == null) {
                SortedSetDocValues dv = MultiDocValues.getSortedSetValues(this.reader, this.field);
                if (dv instanceof MultiDocValues.MultiSortedSetDocValues) {
                    map = ((MultiDocValues.MultiSortedSetDocValues)dv).mapping;
                    IndexReader.CacheHelper cacheHelper = this.reader.getReaderCacheHelper();
                    if (cacheHelper != null && map.owner == cacheHelper.getKey()) {
                        this.cachedOrdMap.put(this.field, map);
                    }
                }
                return dv;
            }
        }
        assert (map != null);
        int size = this.reader.leaves().size();
        SortedSetDocValues[] values = new SortedSetDocValues[size];
        int[] starts = new int[size + 1];
        long cost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = this.reader.leaves().get(i);
            LeafReader reader = context.reader();
            FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(this.field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.SORTED_SET) {
                return null;
            }
            SortedSetDocValues v = reader.getSortedSetDocValues(this.field);
            if (v == null) {
                v = DocValues.emptySortedSet();
            }
            values[i] = v;
            starts[i] = context.docBase;
            cost += v.cost();
        }
        starts[size] = this.reader.maxDoc();
        return new MultiDocValues.MultiSortedSetDocValues(values, starts, map, cost);
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public IndexReader getReader() {
        return this.reader;
    }

    @Override
    public int getSize() {
        return this.valueCount;
    }

    @Override
    public FacetsConfig getFacetsConfig() {
        return this.config;
    }

    @Override
    public Iterable<String> getDims() {
        return () -> new Iterator<String>(){
            final Iterator<String> dimTreeIterator;
            final Iterator<String> ordRangeIterator;
            {
                this.dimTreeIterator = DefaultSortedSetDocValuesReaderState.this.prefixToDimTree.keySet().iterator();
                this.ordRangeIterator = DefaultSortedSetDocValuesReaderState.this.prefixToOrdRange.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.ordRangeIterator.hasNext() || this.dimTreeIterator.hasNext();
            }

            @Override
            public String next() {
                if (this.dimTreeIterator.hasNext()) {
                    return this.dimTreeIterator.next();
                }
                if (this.ordRangeIterator.hasNext()) {
                    return this.ordRangeIterator.next();
                }
                return null;
            }
        };
    }

    @Override
    public Map<String, SortedSetDocValuesReaderState.OrdRange> getPrefixToOrdRange() {
        return this.prefixToOrdRange;
    }

    @Override
    public SortedSetDocValuesReaderState.OrdRange getOrdRange(String dim) {
        if (this.config.getDimConfig((String)dim).hierarchical) {
            throw new UnsupportedOperationException("This operation is only supported for flat dimensions");
        }
        return this.prefixToOrdRange.get(dim);
    }

    @Override
    public SortedSetDocValuesReaderState.DimTree getDimTree(String dim) {
        if (!this.config.getDimConfig((String)dim).hierarchical) {
            throw new UnsupportedOperationException("This operation is only supported for hierarchical facets");
        }
        return this.prefixToDimTree.get(dim);
    }

    private static final class OrdAndComponent {
        int ord;
        String[] component;

        public OrdAndComponent(int ord, String[] component) {
            this.ord = ord;
            this.component = component;
        }
    }
}

