/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.BinaryDocValuesWriter;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.FreqProxTermsWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.NumericDocValuesWriter;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedDocValuesWriter;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedNumericDocValuesWriter;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.SortedSetDocValuesWriter;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOSupplier;

public final class SortingCodecReader
extends FilterCodecReader {
    final Sorter.DocMap docMap;
    final LeafMetaData metaData;
    private String cachedField;
    private Object cachedObject;
    private boolean cacheIsNorms;
    private final Map<String, Integer> cacheStats = new HashMap<String, Integer>();

    public static SortingIteratorSupplier iteratorSupplier(KnnVectorValues values, Sorter.DocMap docMap) throws IOException {
        int[] docToOrd = new int[docMap.size()];
        FixedBitSet docBits = new FixedBitSet(docMap.size());
        int count = 0;
        KnnVectorValues.DocIndexIterator iter = values.iterator();
        int doc = iter.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int newDocId = docMap.oldToNew(doc);
            if (newDocId != -1) {
                docToOrd[newDocId] = iter.index();
                docBits.set(newDocId);
                ++count;
            }
            doc = iter.nextDoc();
        }
        return new SortingIteratorSupplier(docBits, docToOrd, count);
    }

    public static CodecReader wrap(CodecReader reader, Sort sort) throws IOException {
        return SortingCodecReader.wrap(reader, new Sorter(sort).sort(reader), sort);
    }

    public static CodecReader wrap(CodecReader reader, Sorter.DocMap docMap, Sort sort) {
        LeafMetaData metaData = reader.getMetaData();
        final LeafMetaData newMetaData = new LeafMetaData(metaData.createdVersionMajor(), metaData.minVersion(), sort, metaData.hasBlocks());
        if (docMap == null) {
            return new FilterCodecReader(reader){

                @Override
                public IndexReader.CacheHelper getCoreCacheHelper() {
                    return null;
                }

                @Override
                public IndexReader.CacheHelper getReaderCacheHelper() {
                    return null;
                }

                @Override
                public LeafMetaData getMetaData() {
                    return newMetaData;
                }

                public String toString() {
                    return "SortingCodecReader(" + String.valueOf(this.in) + ")";
                }
            };
        }
        if (reader.maxDoc() != docMap.size()) {
            throw new IllegalArgumentException("reader.maxDoc() should be equal to docMap.size(), got " + reader.maxDoc() + " != " + docMap.size());
        }
        assert (Sorter.isConsistent(docMap));
        return new SortingCodecReader(reader, docMap, newMetaData);
    }

    private SortingCodecReader(CodecReader in, Sorter.DocMap docMap, LeafMetaData metaData) {
        super(in);
        this.docMap = docMap;
        this.metaData = metaData;
    }

    @Override
    public FieldsProducer getPostingsReader() {
        final FieldsProducer postingsReader = this.in.getPostingsReader();
        if (postingsReader == null) {
            return null;
        }
        return new FieldsProducer(){

            @Override
            public void close() throws IOException {
                postingsReader.close();
            }

            @Override
            public void checkIntegrity() throws IOException {
                postingsReader.checkIntegrity();
            }

            @Override
            public Iterator<String> iterator() {
                return postingsReader.iterator();
            }

            @Override
            public Terms terms(String field2) throws IOException {
                Terms terms = postingsReader.terms(field2);
                return terms == null ? null : new FreqProxTermsWriter.SortingTerms(terms, SortingCodecReader.this.in.getFieldInfos().fieldInfo(field2).getIndexOptions(), SortingCodecReader.this.docMap);
            }

            @Override
            public int size() {
                return postingsReader.size();
            }
        };
    }

    @Override
    public StoredFieldsReader getFieldsReader() {
        StoredFieldsReader delegate = this.in.getFieldsReader();
        if (delegate == null) {
            return null;
        }
        return this.newStoredFieldsReader(delegate);
    }

    private StoredFieldsReader newStoredFieldsReader(final StoredFieldsReader delegate) {
        return new StoredFieldsReader(){

            @Override
            public void prefetch(int docID) throws IOException {
                delegate.prefetch(SortingCodecReader.this.docMap.newToOld(docID));
            }

            @Override
            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                delegate.document(SortingCodecReader.this.docMap.newToOld(docID), visitor);
            }

            @Override
            public StoredFieldsReader clone() {
                return SortingCodecReader.this.newStoredFieldsReader(delegate.clone());
            }

            @Override
            public void checkIntegrity() throws IOException {
                delegate.checkIntegrity();
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    @Override
    public Bits getLiveDocs() {
        Bits inLiveDocs = this.in.getLiveDocs();
        if (inLiveDocs == null) {
            return null;
        }
        return new SortingBits(inLiveDocs, this.docMap);
    }

    @Override
    public PointsReader getPointsReader() {
        final PointsReader delegate = this.in.getPointsReader();
        if (delegate == null) {
            return null;
        }
        return new PointsReader(){

            @Override
            public void checkIntegrity() throws IOException {
                delegate.checkIntegrity();
            }

            @Override
            public PointValues getValues(String field2) throws IOException {
                PointValues values = delegate.getValues(field2);
                if (values == null) {
                    return null;
                }
                return new SortingPointValues(delegate.getValues(field2), SortingCodecReader.this.docMap);
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    @Override
    public KnnVectorsReader getVectorReader() {
        final KnnVectorsReader delegate = this.in.getVectorReader();
        if (delegate == null) {
            return null;
        }
        return new KnnVectorsReader(){

            @Override
            public void checkIntegrity() throws IOException {
                delegate.checkIntegrity();
            }

            @Override
            public FloatVectorValues getFloatVectorValues(String field2) throws IOException {
                return new SortingFloatVectorValues(delegate.getFloatVectorValues(field2), SortingCodecReader.this.docMap);
            }

            @Override
            public ByteVectorValues getByteVectorValues(String field2) throws IOException {
                return new SortingByteVectorValues(delegate.getByteVectorValues(field2), SortingCodecReader.this.docMap);
            }

            @Override
            public void search(String field2, float[] target, KnnCollector knnCollector, Bits acceptDocs) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void search(String field2, byte[] target, KnnCollector knnCollector, Bits acceptDocs) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    @Override
    public NormsProducer getNormsReader() {
        final NormsProducer delegate = this.in.getNormsReader();
        if (delegate == null) {
            return null;
        }
        return new NormsProducer(){

            @Override
            public NumericDocValues getNorms(FieldInfo field2) throws IOException {
                return new NumericDocValuesWriter.SortingNumericDocValues(SortingCodecReader.this.getOrCreateNorms(field2.name, () -> SortingCodecReader.this.getNumericDocValues(delegate.getNorms(field2))));
            }

            @Override
            public void checkIntegrity() throws IOException {
                delegate.checkIntegrity();
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    @Override
    public DocValuesProducer getDocValuesReader() {
        final DocValuesProducer delegate = this.in.getDocValuesReader();
        if (delegate == null) {
            return null;
        }
        return new DocValuesProducer(){

            @Override
            public NumericDocValues getNumeric(FieldInfo field2) throws IOException {
                return new NumericDocValuesWriter.SortingNumericDocValues(SortingCodecReader.this.getOrCreateDV(field2.name, () -> SortingCodecReader.this.getNumericDocValues(delegate.getNumeric(field2))));
            }

            @Override
            public BinaryDocValues getBinary(FieldInfo field2) throws IOException {
                return new BinaryDocValuesWriter.SortingBinaryDocValues(SortingCodecReader.this.getOrCreateDV(field2.name, () -> new BinaryDocValuesWriter.BinaryDVs(SortingCodecReader.this.maxDoc(), SortingCodecReader.this.docMap, delegate.getBinary(field2))));
            }

            @Override
            public SortedDocValues getSorted(FieldInfo field2) throws IOException {
                SortedDocValues oldDocValues = delegate.getSorted(field2);
                return new SortedDocValuesWriter.SortingSortedDocValues(oldDocValues, SortingCodecReader.this.getOrCreateDV(field2.name, () -> {
                    int docID;
                    int[] ords = new int[SortingCodecReader.this.maxDoc()];
                    Arrays.fill(ords, -1);
                    while ((docID = oldDocValues.nextDoc()) != Integer.MAX_VALUE) {
                        int newDocID = SortingCodecReader.this.docMap.oldToNew(docID);
                        ords[newDocID] = oldDocValues.ordValue();
                    }
                    return ords;
                }));
            }

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo field2) throws IOException {
                SortedNumericDocValues oldDocValues = delegate.getSortedNumeric(field2);
                return new SortedNumericDocValuesWriter.SortingSortedNumericDocValues(oldDocValues, SortingCodecReader.this.getOrCreateDV(field2.name, () -> new SortedNumericDocValuesWriter.LongValues(SortingCodecReader.this.maxDoc(), SortingCodecReader.this.docMap, oldDocValues, 0.5f)));
            }

            @Override
            public SortedSetDocValues getSortedSet(FieldInfo field2) throws IOException {
                SortedSetDocValues oldDocValues = delegate.getSortedSet(field2);
                return new SortedSetDocValuesWriter.SortingSortedSetDocValues(oldDocValues, SortingCodecReader.this.getOrCreateDV(field2.name, () -> new SortedSetDocValuesWriter.DocOrds(SortingCodecReader.this.maxDoc(), SortingCodecReader.this.docMap, oldDocValues, 0.5f, 2)));
            }

            @Override
            public void checkIntegrity() throws IOException {
                delegate.checkIntegrity();
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }

            @Override
            public DocValuesSkipper getSkipper(FieldInfo field2) throws IOException {
                return null;
            }
        };
    }

    private NumericDocValuesWriter.NumericDVs getNumericDocValues(NumericDocValues oldNumerics) throws IOException {
        int docID;
        FixedBitSet docsWithField = new FixedBitSet(this.maxDoc());
        long[] values = new long[this.maxDoc()];
        while ((docID = oldNumerics.nextDoc()) != Integer.MAX_VALUE) {
            int newDocID = this.docMap.oldToNew(docID);
            docsWithField.set(newDocID);
            values[newDocID] = oldNumerics.longValue();
        }
        return new NumericDocValuesWriter.NumericDVs(values, docsWithField);
    }

    @Override
    public TermVectorsReader getTermVectorsReader() {
        return this.newTermVectorsReader(this.in.getTermVectorsReader());
    }

    private TermVectorsReader newTermVectorsReader(final TermVectorsReader delegate) {
        if (delegate == null) {
            return null;
        }
        return new TermVectorsReader(){

            @Override
            public void prefetch(int doc) throws IOException {
                delegate.prefetch(SortingCodecReader.this.docMap.newToOld(doc));
            }

            @Override
            public Fields get(int doc) throws IOException {
                return delegate.get(SortingCodecReader.this.docMap.newToOld(doc));
            }

            @Override
            public void checkIntegrity() throws IOException {
                delegate.checkIntegrity();
            }

            @Override
            public TermVectorsReader clone() {
                return SortingCodecReader.this.newTermVectorsReader(delegate.clone());
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    public String toString() {
        return "SortingCodecReader(" + String.valueOf(this.in) + ")";
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    @Override
    public LeafMetaData getMetaData() {
        return this.metaData;
    }

    private <T> T getOrCreateNorms(String field2, IOSupplier<T> supplier) throws IOException {
        return this.getOrCreate(field2, true, supplier);
    }

    private synchronized <T> T getOrCreate(String field2, boolean norms, IOSupplier<T> supplier) throws IOException {
        if (!(field2.equals(this.cachedField) && this.cacheIsNorms == norms)) {
            assert (this.assertCreatedOnlyOnce(field2, norms));
            this.cachedObject = supplier.get();
            this.cachedField = field2;
            this.cacheIsNorms = norms;
        }
        assert (this.cachedObject != null);
        return (T)this.cachedObject;
    }

    private boolean assertCreatedOnlyOnce(String field2, boolean norms) {
        assert (Thread.holdsLock(this));
        int timesCached = this.cacheStats.compute(field2 + "N:" + norms, (s, i) -> i == null ? 1 : i + 1);
        if (timesCached > 1) {
            assert (!norms) : "[" + field2 + "] norms must not be cached twice";
            boolean isSortField = false;
            if (this.metaData.sort() != null) {
                for (SortField sf : this.metaData.sort().getSort()) {
                    if (!field2.equals(sf.getField())) continue;
                    isSortField = true;
                    break;
                }
            }
            assert (timesCached == 2) : "[" + field2 + "] must not be cached more than twice but was cached: " + timesCached + " times isSortField: " + isSortField;
            assert (isSortField) : "only sort fields should be cached twice but [" + field2 + "] is not a sort field";
        }
        return true;
    }

    private <T> T getOrCreateDV(String field2, IOSupplier<T> supplier) throws IOException {
        return this.getOrCreate(field2, false, supplier);
    }

    static class SortingIteratorSupplier
    implements Supplier<SortingValuesIterator> {
        private final FixedBitSet docBits;
        private final int[] docToOrd;
        private final int size;

        SortingIteratorSupplier(FixedBitSet docBits, int[] docToOrd, int size) {
            this.docBits = docBits;
            this.docToOrd = docToOrd;
            this.size = size;
        }

        @Override
        public SortingValuesIterator get() {
            return new SortingValuesIterator(this.docBits, this.docToOrd, this.size);
        }

        public int size() {
            return this.size;
        }
    }

    private record SortingBits(Bits in, Sorter.DocMap docMap) implements Bits
    {
        @Override
        public boolean get(int index) {
            return this.in.get(this.docMap.newToOld(index));
        }

        @Override
        public int length() {
            return this.in.length();
        }
    }

    private static class SortingByteVectorValues
    extends ByteVectorValues {
        final ByteVectorValues delegate;
        final SortingIteratorSupplier iteratorSupplier;

        SortingByteVectorValues(ByteVectorValues delegate, Sorter.DocMap sortMap) throws IOException {
            this.delegate = delegate;
            this.iteratorSupplier = SortingCodecReader.iteratorSupplier(delegate, sortMap);
        }

        @Override
        public byte[] vectorValue(int ord) throws IOException {
            return this.delegate.vectorValue(ord);
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.iteratorSupplier.get();
        }

        @Override
        public int dimension() {
            return this.delegate.dimension();
        }

        @Override
        public int size() {
            return this.iteratorSupplier.size();
        }

        @Override
        public ByteVectorValues copy() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SortingFloatVectorValues
    extends FloatVectorValues {
        final FloatVectorValues delegate;
        final SortingIteratorSupplier iteratorSupplier;

        SortingFloatVectorValues(FloatVectorValues delegate, Sorter.DocMap sortMap) throws IOException {
            this.delegate = delegate;
            assert (delegate != null);
            this.iteratorSupplier = SortingCodecReader.iteratorSupplier(delegate, sortMap);
        }

        @Override
        public float[] vectorValue(int ord) throws IOException {
            return this.delegate.vectorValue(ord);
        }

        @Override
        public int dimension() {
            return this.delegate.dimension();
        }

        @Override
        public int size() {
            return this.iteratorSupplier.size();
        }

        @Override
        public FloatVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.iteratorSupplier.get();
        }
    }

    public static class SortingValuesIterator
    extends KnnVectorValues.DocIndexIterator {
        private final FixedBitSet docBits;
        private final DocIdSetIterator docsWithValues;
        private final int[] docToOrd;
        int doc = -1;

        SortingValuesIterator(FixedBitSet docBits, int[] docToOrd, int size) {
            this.docBits = docBits;
            this.docToOrd = docToOrd;
            this.docsWithValues = new BitSetIterator(docBits, size);
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int index() {
            assert (this.docBits.get(this.doc));
            return this.docToOrd[this.doc];
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.doc != Integer.MAX_VALUE) {
                this.doc = this.docsWithValues.nextDoc();
            }
            return this.doc;
        }

        @Override
        public long cost() {
            return this.docBits.cardinality();
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SortingIntersectVisitor
    implements PointValues.IntersectVisitor {
        private final Sorter.DocMap docMap;
        private PointValues.IntersectVisitor visitor;

        SortingIntersectVisitor(Sorter.DocMap docMap) {
            this.docMap = docMap;
        }

        private void setIntersectVisitor(PointValues.IntersectVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public void visit(int docID) throws IOException {
            this.visitor.visit(this.docMap.oldToNew(docID));
        }

        @Override
        public void visit(int docID, byte[] packedValue) throws IOException {
            this.visitor.visit(this.docMap.oldToNew(docID), packedValue);
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            return this.visitor.compare(minPackedValue, maxPackedValue);
        }
    }

    private static class SortingPointTree
    implements PointValues.PointTree {
        private final PointValues.PointTree indexTree;
        private final Sorter.DocMap docMap;
        private final SortingIntersectVisitor sortingIntersectVisitor;

        SortingPointTree(PointValues.PointTree indexTree, Sorter.DocMap docMap) {
            this.indexTree = indexTree;
            this.docMap = docMap;
            this.sortingIntersectVisitor = new SortingIntersectVisitor(docMap);
        }

        @Override
        public PointValues.PointTree clone() {
            return new SortingPointTree(this.indexTree.clone(), this.docMap);
        }

        @Override
        public boolean moveToChild() throws IOException {
            return this.indexTree.moveToChild();
        }

        @Override
        public boolean moveToSibling() throws IOException {
            return this.indexTree.moveToSibling();
        }

        @Override
        public boolean moveToParent() throws IOException {
            return this.indexTree.moveToParent();
        }

        @Override
        public byte[] getMinPackedValue() {
            return this.indexTree.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() {
            return this.indexTree.getMaxPackedValue();
        }

        @Override
        public long size() {
            return this.indexTree.size();
        }

        @Override
        public void visitDocIDs(PointValues.IntersectVisitor visitor) throws IOException {
            this.sortingIntersectVisitor.setIntersectVisitor(visitor);
            this.indexTree.visitDocIDs(this.sortingIntersectVisitor);
        }

        @Override
        public void visitDocValues(PointValues.IntersectVisitor visitor) throws IOException {
            this.sortingIntersectVisitor.setIntersectVisitor(visitor);
            this.indexTree.visitDocValues(this.sortingIntersectVisitor);
        }
    }

    private static class SortingPointValues
    extends PointValues {
        private final PointValues in;
        private final Sorter.DocMap docMap;

        SortingPointValues(PointValues in, Sorter.DocMap docMap) {
            this.in = Objects.requireNonNull(in);
            this.docMap = docMap;
        }

        @Override
        public PointValues.PointTree getPointTree() throws IOException {
            return new SortingPointTree(this.in.getPointTree(), this.docMap);
        }

        @Override
        public byte[] getMinPackedValue() throws IOException {
            return this.in.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() throws IOException {
            return this.in.getMaxPackedValue();
        }

        @Override
        public int getNumDimensions() throws IOException {
            return this.in.getNumDimensions();
        }

        @Override
        public int getNumIndexDimensions() throws IOException {
            return this.in.getNumIndexDimensions();
        }

        @Override
        public int getBytesPerDimension() throws IOException {
            return this.in.getBytesPerDimension();
        }

        @Override
        public long size() {
            return this.in.size();
        }

        @Override
        public int getDocCount() {
            return this.in.getDocCount();
        }
    }
}

