/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.RamUsageEstimator;

public abstract class PointInSetQuery
extends Query
implements Accountable {
    protected static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(PointInSetQuery.class);
    final PrefixCodedTerms sortedPackedPoints;
    final int sortedPackedPointsHashCode;
    final String field;
    final int numDims;
    final int bytesPerDim;
    final long ramBytesUsed;

    protected PointInSetQuery(String field2, int numDims, int bytesPerDim, Stream packedPoints) {
        BytesRef current;
        this.field = field2;
        if (bytesPerDim < 1 || bytesPerDim > 16) {
            throw new IllegalArgumentException("bytesPerDim must be > 0 and <= 16; got " + bytesPerDim);
        }
        this.bytesPerDim = bytesPerDim;
        if (numDims < 1 || numDims > 8) {
            throw new IllegalArgumentException("numDims must be > 0 and <= 8; got " + numDims);
        }
        this.numDims = numDims;
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        BytesRefBuilder previous = null;
        while ((current = packedPoints.next()) != null) {
            if (current.length != numDims * bytesPerDim) {
                throw new IllegalArgumentException("packed point length should be " + numDims * bytesPerDim + " but got " + current.length + "; field=\"" + field2 + "\" numDims=" + numDims + " bytesPerDim=" + bytesPerDim);
            }
            if (previous == null) {
                previous = new BytesRefBuilder();
            } else {
                int cmp = previous.get().compareTo(current);
                if (cmp == 0) continue;
                if (cmp > 0) {
                    throw new IllegalArgumentException("values are out of order: saw " + String.valueOf(previous) + " before " + String.valueOf(current));
                }
            }
            builder.add(field2, current);
            previous.copyBytes(current);
        }
        this.sortedPackedPoints = builder.finish();
        this.sortedPackedPointsHashCode = this.sortedPackedPoints.hashCode();
        this.ramBytesUsed = BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(field2) + RamUsageEstimator.sizeOfObject(this.sortedPackedPoints);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public final Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final LeafReader reader = context.reader();
                final PointValues values = reader.getPointValues(PointInSetQuery.this.field);
                if (values == null) {
                    return null;
                }
                if (values.getNumIndexDimensions() != PointInSetQuery.this.numDims) {
                    throw new IllegalArgumentException("field=\"" + PointInSetQuery.this.field + "\" was indexed with numIndexDims=" + values.getNumIndexDimensions() + " but this query has numIndexDims=" + PointInSetQuery.this.numDims);
                }
                if (values.getBytesPerDimension() != PointInSetQuery.this.bytesPerDim) {
                    throw new IllegalArgumentException("field=\"" + PointInSetQuery.this.field + "\" was indexed with bytesPerDim=" + values.getBytesPerDimension() + " but this query has bytesPerDim=" + PointInSetQuery.this.bytesPerDim);
                }
                if (PointInSetQuery.this.numDims == 1) {
                    return new ScorerSupplier(){
                        long cost = -1L;

                        @Override
                        public Scorer get(long leadCost) throws IOException {
                            DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values);
                            values.intersect(new MergePointVisitor(PointInSetQuery.this, PointInSetQuery.this.sortedPackedPoints, result));
                            DocIdSetIterator iterator = result.build().iterator();
                            return new ConstantScoreScorer(this.score(), scoreMode, iterator);
                        }

                        @Override
                        public long cost() {
                            try {
                                if (this.cost == -1L) {
                                    DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values);
                                    this.cost = values.estimateDocCount(new MergePointVisitor(PointInSetQuery.this, PointInSetQuery.this.sortedPackedPoints, result));
                                    assert (this.cost >= 0L);
                                }
                                return this.cost;
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }
                    };
                }
                return new ScorerSupplier(){
                    long cost = -1L;

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values);
                        SinglePointVisitor visitor = new SinglePointVisitor(result);
                        PrefixCodedTerms.TermIterator iterator = PointInSetQuery.this.sortedPackedPoints.iterator();
                        BytesRef point = iterator.next();
                        while (point != null) {
                            visitor.setPoint(point);
                            values.intersect(visitor);
                            point = iterator.next();
                        }
                        return new ConstantScoreScorer(this.score(), scoreMode, result.build().iterator());
                    }

                    @Override
                    public long cost() {
                        try {
                            if (this.cost == -1L) {
                                DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values);
                                SinglePointVisitor visitor = new SinglePointVisitor(result);
                                PrefixCodedTerms.TermIterator iterator = PointInSetQuery.this.sortedPackedPoints.iterator();
                                this.cost = 0L;
                                BytesRef point = iterator.next();
                                while (point != null) {
                                    visitor.setPoint(point);
                                    this.cost += values.estimateDocCount(visitor);
                                    point = iterator.next();
                                }
                                assert (this.cost >= 0L);
                            }
                            return this.cost;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                };
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public Collection<byte[]> getPackedPoints() {
        return new AbstractCollection<byte[]>(){

            @Override
            public Iterator<byte[]> iterator() {
                final int size = (int)PointInSetQuery.this.sortedPackedPoints.size();
                final PrefixCodedTerms.TermIterator iterator = PointInSetQuery.this.sortedPackedPoints.iterator();
                return new Iterator<byte[]>(){
                    int upto = 0;

                    @Override
                    public boolean hasNext() {
                        return this.upto < size;
                    }

                    @Override
                    public byte[] next() {
                        if (this.upto == size) {
                            throw new NoSuchElementException();
                        }
                        ++this.upto;
                        BytesRef next = iterator.next();
                        return BytesRef.deepCopyOf((BytesRef)next).bytes;
                    }
                };
            }

            @Override
            public int size() {
                return (int)PointInSetQuery.this.sortedPackedPoints.size();
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public int getNumDims() {
        return this.numDims;
    }

    public int getBytesPerDim() {
        return this.bytesPerDim;
    }

    @Override
    public final int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + this.sortedPackedPointsHashCode;
        hash = 31 * hash + this.numDims;
        hash = 31 * hash + this.bytesPerDim;
        return hash;
    }

    @Override
    public final boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((PointInSetQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(PointInSetQuery other) {
        return other.field.equals(this.field) && other.numDims == this.numDims && other.bytesPerDim == this.bytesPerDim && other.sortedPackedPointsHashCode == this.sortedPackedPointsHashCode && other.sortedPackedPoints.equals(this.sortedPackedPoints);
    }

    @Override
    public final String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field2)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("{");
        PrefixCodedTerms.TermIterator iterator = this.sortedPackedPoints.iterator();
        byte[] pointBytes = new byte[this.numDims * this.bytesPerDim];
        boolean first = true;
        BytesRef point = iterator.next();
        while (point != null) {
            if (!first) {
                sb.append(" ");
            }
            first = false;
            System.arraycopy(point.bytes, point.offset, pointBytes, 0, pointBytes.length);
            sb.append(this.toString(pointBytes));
            point = iterator.next();
        }
        sb.append("}");
        return sb.toString();
    }

    protected abstract String toString(byte[] var1);

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    public static abstract class Stream
    implements BytesRefIterator {
        @Override
        public abstract BytesRef next();
    }

    private class SinglePointVisitor
    implements PointValues.IntersectVisitor {
        private final ArrayUtil.ByteArrayComparator comparator;
        private final DocIdSetBuilder result;
        private final byte[] pointBytes;
        private DocIdSetBuilder.BulkAdder adder;

        public SinglePointVisitor(DocIdSetBuilder result) {
            this.comparator = ArrayUtil.getUnsignedComparator(PointInSetQuery.this.bytesPerDim);
            this.result = result;
            this.pointBytes = new byte[PointInSetQuery.this.bytesPerDim * PointInSetQuery.this.numDims];
        }

        public void setPoint(BytesRef point) {
            assert (point.length == this.pointBytes.length);
            System.arraycopy(point.bytes, point.offset, this.pointBytes, 0, this.pointBytes.length);
        }

        @Override
        public void grow(int count) {
            this.adder = this.result.grow(count);
        }

        @Override
        public void visit(int docID) {
            this.adder.add(docID);
        }

        @Override
        public void visit(DocIdSetIterator iterator) throws IOException {
            this.adder.add(iterator);
        }

        @Override
        public void visit(int docID, byte[] packedValue) {
            assert (packedValue.length == this.pointBytes.length);
            if (Arrays.equals(packedValue, this.pointBytes)) {
                this.visit(docID);
            }
        }

        @Override
        public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
            assert (packedValue.length == this.pointBytes.length);
            if (Arrays.equals(packedValue, this.pointBytes)) {
                this.adder.add(iterator);
            }
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            boolean crosses = false;
            for (int dim = 0; dim < PointInSetQuery.this.numDims; ++dim) {
                int offset = dim * PointInSetQuery.this.bytesPerDim;
                int cmpMin = this.comparator.compare(minPackedValue, offset, this.pointBytes, offset);
                if (cmpMin > 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                int cmpMax = this.comparator.compare(maxPackedValue, offset, this.pointBytes, offset);
                if (cmpMax < 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (cmpMin == 0 && cmpMax == 0) continue;
                crosses = true;
            }
            if (crosses) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
    }

    private class MergePointVisitor
    implements PointValues.IntersectVisitor {
        private final DocIdSetBuilder result;
        private PrefixCodedTerms.TermIterator iterator;
        private BytesRef nextQueryPoint;
        private final ArrayUtil.ByteArrayComparator comparator;
        private final PrefixCodedTerms sortedPackedPoints;
        private DocIdSetBuilder.BulkAdder adder;

        public MergePointVisitor(PointInSetQuery pointInSetQuery, PrefixCodedTerms sortedPackedPoints, DocIdSetBuilder result) throws IOException {
            this.result = result;
            this.sortedPackedPoints = sortedPackedPoints;
            this.comparator = ArrayUtil.getUnsignedComparator(pointInSetQuery.bytesPerDim);
            this.iterator = this.sortedPackedPoints.iterator();
            this.nextQueryPoint = this.iterator.next();
        }

        @Override
        public void grow(int count) {
            this.adder = this.result.grow(count);
        }

        @Override
        public void visit(int docID) {
            this.adder.add(docID);
        }

        @Override
        public void visit(DocIdSetIterator iterator) throws IOException {
            this.adder.add(iterator);
        }

        @Override
        public void visit(int docID, byte[] packedValue) {
            if (this.matches(packedValue)) {
                this.visit(docID);
            }
        }

        @Override
        public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
            if (this.matches(packedValue)) {
                this.adder.add(iterator);
            }
        }

        private boolean matches(byte[] packedValue) {
            while (this.nextQueryPoint != null) {
                int cmp = this.comparator.compare(this.nextQueryPoint.bytes, this.nextQueryPoint.offset, packedValue, 0);
                if (cmp == 0) {
                    return true;
                }
                if (cmp >= 0) break;
                this.nextQueryPoint = this.iterator.next();
            }
            return false;
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            while (this.nextQueryPoint != null) {
                int cmpMin = this.comparator.compare(this.nextQueryPoint.bytes, this.nextQueryPoint.offset, minPackedValue, 0);
                if (cmpMin < 0) {
                    this.nextQueryPoint = this.iterator.next();
                    continue;
                }
                int cmpMax = this.comparator.compare(this.nextQueryPoint.bytes, this.nextQueryPoint.offset, maxPackedValue, 0);
                if (cmpMax > 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (cmpMin == 0 && cmpMax == 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
    }
}

