/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.GroupVIntUtil;

public abstract class DataInput
implements Cloneable {
    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public void readBytes(byte[] b, int offset, int len, boolean useBuffer) throws IOException {
        this.readBytes(b, offset, len);
    }

    public short readShort() throws IOException {
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    public int readInt() throws IOException {
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        byte b3 = this.readByte();
        byte b4 = this.readByte();
        return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public void readGroupVInt(int[] dst, int offset) throws IOException {
        GroupVIntUtil.readGroupVInt(this, dst, offset);
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public int readZInt() throws IOException {
        return BitUtil.zigZagDecode(this.readVInt());
    }

    public long readLong() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL | (long)this.readInt() << 32;
    }

    public void readLongs(long[] dst, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, dst.length);
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = this.readLong();
        }
    }

    public void readInts(int[] dst, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, dst.length);
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = this.readInt();
        }
    }

    public void readFloats(float[] floats, int offset, int len) throws IOException {
        Objects.checkFromIndexSize(offset, len, floats.length);
        for (int i = 0; i < len; ++i) {
            floats[offset + i] = Float.intBitsToFloat(this.readInt());
        }
    }

    public long readVLong() throws IOException {
        byte b = this.readByte();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public long readZLong() throws IOException {
        return BitUtil.zigZagDecode(this.readVLong());
    }

    public String readString() throws IOException {
        int length = this.readVInt();
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new String(bytes, 0, length, StandardCharsets.UTF_8);
    }

    public DataInput clone() {
        try {
            return (DataInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("This cannot happen: Failing to clone DataInput", e);
        }
    }

    public Map<String, String> readMapOfStrings() throws IOException {
        int count = this.readVInt();
        if (count == 0) {
            return Collections.emptyMap();
        }
        if (count == 1) {
            return Collections.singletonMap(this.readString(), this.readString());
        }
        AbstractMap map = count > 10 ? new HashMap() : new TreeMap();
        for (int i = 0; i < count; ++i) {
            String key2 = this.readString();
            String val = this.readString();
            map.put(key2, val);
        }
        return Collections.unmodifiableMap(map);
    }

    public Set<String> readSetOfStrings() throws IOException {
        int count = this.readVInt();
        if (count == 0) {
            return Collections.emptySet();
        }
        if (count == 1) {
            return Collections.singleton(this.readString());
        }
        AbstractSet set = count > 10 ? new HashSet() : new TreeSet();
        for (int i = 0; i < count; ++i) {
            set.add(this.readString());
        }
        return Collections.unmodifiableSet(set);
    }

    public abstract void skipBytes(long var1) throws IOException;
}

