/*
 * Decompiled with CFR 0.152.
 */
package ujson;

import scala.Byte$;
import scala.Int$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import upickle.core.ArrVisitor;
import upickle.core.ObjVisitor;
import upickle.core.Visitor;

public interface JsVisitor<T, J>
extends Visitor<T, J> {
    public static Object visitFloat64$(JsVisitor $this, double d, int index) {
        return $this.visitFloat64(d, index);
    }

    @Override
    default public J visitFloat64(double d, int index) {
        if (d == Double.POSITIVE_INFINITY) {
            return this.visitString("Infinity", index);
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return this.visitString("-Infinity", index);
        }
        long i = (long)d;
        if ((double)i == d) {
            return this.visitFloat64StringParts(BoxesRunTime.boxToLong(i).toString(), -1, -1, index);
        }
        return this.visitFloat64String(BoxesRunTime.boxToDouble(d).toString(), index);
    }

    public static Object visitFloat32$(JsVisitor $this, float d, int index) {
        return $this.visitFloat32(d, index);
    }

    @Override
    default public J visitFloat32(float d, int index) {
        if (d == Float.POSITIVE_INFINITY) {
            return this.visitString("Infinity", index);
        }
        if (d == Float.NEGATIVE_INFINITY) {
            return this.visitString("-Infinity", index);
        }
        long i = (long)d;
        if ((float)i == d) {
            return this.visitFloat64StringParts(BoxesRunTime.boxToLong(i).toString(), -1, -1, index);
        }
        return this.visitFloat64String(BoxesRunTime.boxToFloat(d).toString(), index);
    }

    public static Object visitInt32$(JsVisitor $this, int i, int index) {
        return $this.visitInt32(i, index);
    }

    @Override
    default public J visitInt32(int i, int index) {
        return this.visitFloat64(Int$.MODULE$.int2double(i), index);
    }

    public static Object visitInt64$(JsVisitor $this, long i, int index) {
        return $this.visitInt64(i, index);
    }

    @Override
    default public J visitInt64(long i, int index) {
        if (package$.MODULE$.abs(i) > 0x20000000000000L || i == Long.MIN_VALUE) {
            return this.visitString(BoxesRunTime.boxToLong(i).toString(), index);
        }
        return this.visitFloat64(i, index);
    }

    public static Object visitUInt64$(JsVisitor $this, long i, int index) {
        return $this.visitUInt64(i, index);
    }

    @Override
    default public J visitUInt64(long i, int index) {
        if (i > 0x20000000000000L || i < 0L) {
            return this.visitString(Long.toUnsignedString(i), index);
        }
        return this.visitFloat64(i, index);
    }

    public static Object visitFloat64String$(JsVisitor $this, String s, int index) {
        return $this.visitFloat64String(s, index);
    }

    @Override
    default public J visitFloat64String(String s, int index) {
        int n;
        int n2 = s.indexOf(69);
        int n3 = -1 == n2 ? s.indexOf(101) : (n = n2);
        return this.visitFloat64StringParts(s, s.indexOf(46), n3, -1);
    }

    public static Object visitBinary$(JsVisitor $this, byte[] bytes, int offset, int len, int index) {
        return $this.visitBinary(bytes, offset, len, index);
    }

    @Override
    default public J visitBinary(byte[] bytes, int offset, int len, int index) {
        ArrVisitor arr = this.visitArray(len, index);
        for (int i = 0; i < len; ++i) {
            arr.visitValue(arr.subVisitor().visitInt32(Byte$.MODULE$.byte2int(bytes[offset + i]), index), index);
        }
        return arr.visitEnd(index);
    }

    public static Object visitFloat64StringParts$(JsVisitor $this, CharSequence s, int decIndex, int expIndex) {
        return $this.visitFloat64StringParts(s, decIndex, expIndex);
    }

    default public J visitFloat64StringParts(CharSequence s, int decIndex, int expIndex) {
        return this.visitFloat64StringParts(s, decIndex, expIndex, -1);
    }

    public static Object visitExt$(JsVisitor $this, byte tag, byte[] bytes, int offset, int len, int index) {
        return $this.visitExt(tag, bytes, offset, len, index);
    }

    @Override
    default public J visitExt(byte tag, byte[] bytes, int offset, int len, int index) {
        ArrVisitor arr = this.visitArray(-1, index);
        arr.visitValue(this.visitFloat64(Byte$.MODULE$.byte2double(tag), index), -1);
        arr.visitValue(this.visitBinary(bytes, offset, len, index), -1);
        return arr.visitEnd(-1);
    }

    public static Object visitChar$(JsVisitor $this, char s, int index) {
        return $this.visitChar(s, index);
    }

    @Override
    default public J visitChar(char s, int index) {
        return this.visitString(BoxesRunTime.boxToCharacter(s).toString(), index);
    }

    public ObjVisitor<T, J> visitJsonableObject(int var1, int var2);

    public static ObjVisitor visitObject$(JsVisitor $this, int length, boolean jsonableKeys, int index) {
        return $this.visitObject(length, jsonableKeys, index);
    }

    @Override
    default public ObjVisitor<T, J> visitObject(int length, boolean jsonableKeys, int index) {
        if (jsonableKeys) {
            return this.visitJsonableObject(length, index);
        }
        return new ObjVisitor<T, J>(length, index, this){
            private final ArrVisitor wrapped;
            private int lastKeyIndex;
            private ArrVisitor lastNested;
            private final /* synthetic */ JsVisitor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.wrapped = $outer.visitArray(length$1, index$1);
                this.lastKeyIndex = -1;
                this.lastNested = null;
            }

            public ArrVisitor wrapped() {
                return this.wrapped;
            }

            public int lastKeyIndex() {
                return this.lastKeyIndex;
            }

            public void lastKeyIndex_$eq(int x$1) {
                this.lastKeyIndex = x$1;
            }

            public ArrVisitor lastNested() {
                return this.lastNested;
            }

            public void lastNested_$eq(ArrVisitor x$1) {
                this.lastNested = x$1;
            }

            public Visitor subVisitor() {
                return this.$outer;
            }

            public Visitor visitKey(int index) {
                this.lastNested_$eq(this.wrapped().subVisitor().visitArray(2, index));
                this.lastKeyIndex_$eq(index);
                return this.$outer;
            }

            public void visitKeyValue(Object s) {
                this.lastNested().visitValue(s, this.lastKeyIndex());
            }

            public void visitValue(Object v, int index) {
                this.lastNested().visitValue(v, index);
                this.wrapped().visitValue(this.lastNested().visitEnd(index), index);
            }

            public Object visitEnd(int index) {
                return this.wrapped().visitEnd(index);
            }
        };
    }
}

