/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.message2;

import com.ibm.icu.message2.Directionality;
import com.ibm.icu.message2.FormattedPlaceholder;
import com.ibm.icu.message2.Function;
import com.ibm.icu.message2.FunctionFactory;
import com.ibm.icu.message2.MFDataModel;
import com.ibm.icu.message2.OptUtils;
import com.ibm.icu.message2.PlainStringFormattedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

class TextFunctionFactory
implements FunctionFactory {
    TextFunctionFactory() {
    }

    @Override
    public Function create(Locale locale, Map<String, Object> fixedOptions) {
        return new TextFunctionImpl(OptUtils.getDirectionality(fixedOptions));
    }

    private static class TextFunctionImpl
    implements Function {
        private final Directionality directionality;

        public TextFunctionImpl(Directionality directionality) {
            this.directionality = directionality == null ? Directionality.INHERIT : directionality;
        }

        @Override
        public String formatToString(Object toFormat, Map<String, Object> variableOptions) {
            return this.format(toFormat, variableOptions).toString();
        }

        @Override
        public FormattedPlaceholder format(Object toFormat, Map<String, Object> variableOptions) {
            return new FormattedPlaceholder(toFormat, new PlainStringFormattedValue(Objects.toString(toFormat)), this.directionality, true);
        }

        @Override
        public List<String> matches(Object value, List<String> keys, Map<String, Object> variableOptions) {
            ArrayList<String> result = new ArrayList<String>();
            if (value == null) {
                if (OptUtils.reportErrors(variableOptions)) {
                    throw new IllegalArgumentException("unresolved-variable: argument to match on can't be null");
                }
                return result;
            }
            for (String key2 : keys) {
                if (!this.matches(value, key2)) continue;
                result.add(key2);
            }
            result.sort(String::compareTo);
            return result;
        }

        private boolean matches(Object value, String key2) {
            if (MFDataModel.CatchallKey.isCatchAll(key2)) {
                return true;
            }
            return key2.equals(Objects.toString(value));
        }
    }
}

