/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongDistanceFeatureQuery;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredValue;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public final class LongField
extends Field {
    private static final FieldType FIELD_TYPE = new FieldType();
    private static final FieldType FIELD_TYPE_STORED;
    private final StoredValue storedValue;

    public LongField(String name, long value, Field.Store stored) {
        super(name, stored == Field.Store.YES ? FIELD_TYPE_STORED : FIELD_TYPE);
        this.fieldsData = value;
        this.storedValue = stored == Field.Store.YES ? new StoredValue(value) : null;
    }

    @Override
    public BytesRef binaryValue() {
        byte[] bytes = new byte[8];
        NumericUtils.longToSortableBytes((Long)this.fieldsData, bytes, 0);
        return new BytesRef(bytes);
    }

    @Override
    public StoredValue storedValue() {
        return this.storedValue;
    }

    @Override
    public void setLongValue(long value) {
        super.setLongValue(value);
        if (this.storedValue != null) {
            this.storedValue.setLongValue(value);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " <" + this.name + ":" + String.valueOf(this.fieldsData) + ">";
    }

    public static Query newExactQuery(String field2, long value) {
        return LongField.newRangeQuery(field2, value, value);
    }

    public static Query newRangeQuery(String field2, long lowerValue, long upperValue) {
        PointRangeQuery.checkArgs(field2, lowerValue, upperValue);
        IndexOrDocValuesQuery fallbackQuery = new IndexOrDocValuesQuery(LongPoint.newRangeQuery(field2, lowerValue, upperValue), SortedNumericDocValuesField.newSlowRangeQuery(field2, lowerValue, upperValue));
        return new IndexSortSortedNumericDocValuesRangeQuery(field2, lowerValue, upperValue, fallbackQuery);
    }

    public static Query newSetQuery(String field2, long ... values) {
        if (field2 == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        long[] points = (long[])values.clone();
        return new IndexOrDocValuesQuery(LongPoint.newSetQuery(field2, points), SortedNumericDocValuesField.newSlowSetQuery(field2, points));
    }

    public static SortField newSortField(String field2, boolean reverse, SortedNumericSelector.Type selector) {
        return new SortedNumericSortField(field2, SortField.Type.LONG, reverse, selector);
    }

    public static Query newDistanceFeatureQuery(String field2, float weight, long origin, long pivotDistance) {
        Query query = new LongDistanceFeatureQuery(field2, origin, pivotDistance);
        if (weight != 1.0f) {
            query = new BoostQuery(query, weight);
        }
        return query;
    }

    static {
        FIELD_TYPE.setDimensions(1, 8);
        FIELD_TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        FIELD_TYPE.freeze();
        FIELD_TYPE_STORED = new FieldType(FIELD_TYPE);
        FIELD_TYPE_STORED.setStored(true);
        FIELD_TYPE_STORED.freeze();
    }
}

