/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.MultiLongValues;
import org.apache.lucene.facet.MultiLongValuesSource;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeCounter;
import org.apache.lucene.facet.range.RangeFacetCounts;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Query;

public class LongRangeFacetCounts
extends RangeFacetCounts {
    public LongRangeFacetCounts(String field2, FacetsCollector hits, LongRange ... ranges) throws IOException {
        this(field2, (LongValuesSource)null, hits, ranges);
    }

    public LongRangeFacetCounts(String field2, LongValuesSource valueSource, FacetsCollector hits, LongRange ... ranges) throws IOException {
        this(field2, valueSource, hits, (Query)null, ranges);
    }

    public LongRangeFacetCounts(String field2, MultiLongValuesSource valuesSource, FacetsCollector hits, LongRange ... ranges) throws IOException {
        this(field2, valuesSource, hits, (Query)null, ranges);
    }

    public LongRangeFacetCounts(String field2, LongValuesSource valueSource, FacetsCollector hits, Query fastMatchQuery, LongRange ... ranges) throws IOException {
        super(field2, ranges, fastMatchQuery);
        if (valueSource != null) {
            this.count(valueSource, hits.getMatchingDocs());
        } else {
            this.count(field2, hits.getMatchingDocs());
        }
    }

    public LongRangeFacetCounts(String field2, MultiLongValuesSource valuesSource, FacetsCollector hits, Query fastMatchQuery, LongRange ... ranges) throws IOException {
        super(field2, ranges, fastMatchQuery);
        if (valuesSource != null) {
            LongValuesSource singleValues = MultiLongValuesSource.unwrapSingleton(valuesSource);
            if (singleValues != null) {
                this.count(singleValues, hits.getMatchingDocs());
            } else {
                this.count(valuesSource, hits.getMatchingDocs());
            }
        } else {
            this.count(field2, hits.getMatchingDocs());
        }
    }

    private void count(LongValuesSource valueSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        LongRangeCounter counter = null;
        int missingCount = 0;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            DocIdSetIterator it;
            if (hits.totalHits() == 0 || (it = this.createIterator(hits, new DocIdSetIterator[0])) == null) continue;
            if (counter == null) {
                counter = this.setupCounter();
            }
            LongValues fv = valueSource.getValues(hits.context(), null);
            this.totCount += hits.totalHits();
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (fv.advanceExact(doc)) {
                    counter.addSingleValued(fv.longValue());
                } else {
                    ++missingCount;
                }
                doc = it.nextDoc();
            }
        }
        if (counter != null) {
            this.totCount -= (missingCount += counter.finish());
        }
    }

    private void count(MultiLongValuesSource valueSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        LongRangeCounter counter = null;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            DocIdSetIterator it;
            if (hits.totalHits() == 0 || (it = this.createIterator(hits, new DocIdSetIterator[0])) == null) continue;
            if (counter == null) {
                counter = this.setupCounter();
            }
            MultiLongValues multiValues = valueSource.getValues(hits.context());
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (multiValues.advanceExact(doc)) {
                    long limit = multiValues.getValueCount();
                    if (limit == 1L) {
                        counter.addSingleValued(multiValues.nextValue());
                        ++this.totCount;
                    } else {
                        counter.startMultiValuedDoc();
                        long previous = 0L;
                        int i = 0;
                        while ((long)i < limit) {
                            long val = multiValues.nextValue();
                            if (i == 0 || val != previous) {
                                counter.addMultiValued(val);
                                previous = val;
                            }
                            ++i;
                        }
                        if (counter.endMultiValuedDoc()) {
                            ++this.totCount;
                        }
                    }
                }
                doc = it.nextDoc();
            }
        }
        if (counter != null) {
            int missingCount = counter.finish();
            this.totCount -= missingCount;
        }
    }

    @Override
    protected LongRange[] getLongRanges() {
        return (LongRange[])this.ranges;
    }
}

