/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRef;

public abstract class PointValues {
    public static final int MAX_NUM_BYTES = 16;
    public static final int MAX_DIMENSIONS = 16;
    public static final int MAX_INDEX_DIMENSIONS = 8;

    public static long size(IndexReader reader, String field2) throws IOException {
        long size = 0L;
        for (LeafReaderContext ctx : reader.leaves()) {
            PointValues values = ctx.reader().getPointValues(field2);
            if (values == null) continue;
            size += values.size();
        }
        return size;
    }

    public static int getDocCount(IndexReader reader, String field2) throws IOException {
        int count = 0;
        for (LeafReaderContext ctx : reader.leaves()) {
            PointValues values = ctx.reader().getPointValues(field2);
            if (values == null) continue;
            count += values.getDocCount();
        }
        return count;
    }

    public static byte[] getMinPackedValue(IndexReader reader, String field2) throws IOException {
        byte[] minValue = null;
        for (LeafReaderContext ctx : reader.leaves()) {
            byte[] leafMinValue;
            PointValues values = ctx.reader().getPointValues(field2);
            if (values == null || (leafMinValue = values.getMinPackedValue()) == null) continue;
            if (minValue == null) {
                minValue = (byte[])leafMinValue.clone();
                continue;
            }
            int numDimensions = values.getNumIndexDimensions();
            int numBytesPerDimension = values.getBytesPerDimension();
            ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator(numBytesPerDimension);
            for (int i = 0; i < numDimensions; ++i) {
                int offset = i * numBytesPerDimension;
                if (comparator.compare(leafMinValue, offset, minValue, offset) >= 0) continue;
                System.arraycopy(leafMinValue, offset, minValue, offset, numBytesPerDimension);
            }
        }
        return minValue;
    }

    public static byte[] getMaxPackedValue(IndexReader reader, String field2) throws IOException {
        byte[] maxValue = null;
        for (LeafReaderContext ctx : reader.leaves()) {
            byte[] leafMaxValue;
            PointValues values = ctx.reader().getPointValues(field2);
            if (values == null || (leafMaxValue = values.getMaxPackedValue()) == null) continue;
            if (maxValue == null) {
                maxValue = (byte[])leafMaxValue.clone();
                continue;
            }
            int numDimensions = values.getNumIndexDimensions();
            int numBytesPerDimension = values.getBytesPerDimension();
            ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator(numBytesPerDimension);
            for (int i = 0; i < numDimensions; ++i) {
                int offset = i * numBytesPerDimension;
                if (comparator.compare(leafMaxValue, offset, maxValue, offset) <= 0) continue;
                System.arraycopy(leafMaxValue, offset, maxValue, offset, numBytesPerDimension);
            }
        }
        return maxValue;
    }

    protected PointValues() {
    }

    public abstract PointTree getPointTree() throws IOException;

    public final void intersect(IntersectVisitor visitor) throws IOException {
        PointTree pointTree = this.getPointTree();
        PointValues.intersect(visitor, pointTree);
        assert (!pointTree.moveToParent());
    }

    /*
     * Unable to fully structure code
     */
    private static void intersect(IntersectVisitor visitor, PointTree pointTree) throws IOException {
        block0: while (true) {
            if ((compare = visitor.compare(pointTree.getMinPackedValue(), pointTree.getMaxPackedValue())) == Relation.CELL_INSIDE_QUERY) {
                pointTree.visitDocIDs(visitor);
            } else if (compare == Relation.CELL_CROSSES_QUERY) {
                if (pointTree.moveToChild()) continue;
                pointTree.visitDocValues(visitor);
            }
            do {
                if (!pointTree.moveToSibling()) ** break;
                continue block0;
            } while (pointTree.moveToParent());
            break;
        }
    }

    public final long estimatePointCount(IntersectVisitor visitor) {
        try {
            PointTree pointTree = this.getPointTree();
            long count = PointValues.estimatePointCount(visitor, pointTree, Long.MAX_VALUE);
            assert (!pointTree.moveToParent());
            return count;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static boolean isEstimatedPointCountGreaterThanOrEqualTo(IntersectVisitor visitor, PointTree pointTree, long upperBound) throws IOException {
        return PointValues.estimatePointCount(visitor, pointTree, upperBound) >= upperBound;
    }

    private static long estimatePointCount(IntersectVisitor visitor, PointTree pointTree, long upperBound) throws IOException {
        Relation r = visitor.compare(pointTree.getMinPackedValue(), pointTree.getMaxPackedValue());
        switch (r.ordinal()) {
            case 1: {
                return 0L;
            }
            case 0: {
                return pointTree.size();
            }
            case 2: {
                if (pointTree.moveToChild()) {
                    long cost = 0L;
                    while ((cost += PointValues.estimatePointCount(visitor, pointTree, upperBound - cost)) < upperBound && pointTree.moveToSibling()) {
                    }
                    pointTree.moveToParent();
                    return cost;
                }
                return (pointTree.size() + 1L) / 2L;
            }
        }
        throw new IllegalArgumentException("Unreachable code");
    }

    public final long estimateDocCount(IntersectVisitor visitor) {
        long estimatedPointCount = this.estimatePointCount(visitor);
        int docCount = this.getDocCount();
        double size = this.size();
        if ((double)estimatedPointCount >= size) {
            return docCount;
        }
        if (size == (double)docCount || estimatedPointCount == 0L) {
            return estimatedPointCount;
        }
        long docEstimate = (long)((double)docCount * (1.0 - Math.pow((size - (double)estimatedPointCount) / size, size / (double)docCount)));
        return docEstimate == 0L ? 1L : docEstimate;
    }

    public abstract byte[] getMinPackedValue() throws IOException;

    public abstract byte[] getMaxPackedValue() throws IOException;

    public abstract int getNumDimensions() throws IOException;

    public abstract int getNumIndexDimensions() throws IOException;

    public abstract int getBytesPerDimension() throws IOException;

    public abstract long size();

    public abstract int getDocCount();

    public static interface PointTree
    extends Cloneable {
        public PointTree clone();

        public boolean moveToChild() throws IOException;

        public boolean moveToSibling() throws IOException;

        public boolean moveToParent() throws IOException;

        public byte[] getMinPackedValue();

        public byte[] getMaxPackedValue();

        public long size();

        public void visitDocIDs(IntersectVisitor var1) throws IOException;

        public void visitDocValues(IntersectVisitor var1) throws IOException;
    }

    public static interface IntersectVisitor {
        public void visit(int var1) throws IOException;

        default public void visit(DocIdSetIterator iterator) throws IOException {
            int docID;
            while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                this.visit(docID);
            }
        }

        default public void visit(IntsRef ref) throws IOException {
            for (int i = ref.offset; i < ref.length + ref.offset; ++i) {
                this.visit(ref.ints[i]);
            }
        }

        public void visit(int var1, byte[] var2) throws IOException;

        default public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
            int docID;
            while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                this.visit(docID, packedValue);
            }
        }

        public Relation compare(byte[] var1, byte[] var2);

        default public void grow(int count) {
        }
    }

    public static enum Relation {
        CELL_INSIDE_QUERY,
        CELL_OUTSIDE_QUERY,
        CELL_CROSSES_QUERY;

    }
}

