/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

final class SlowCompositeCodecReaderWrapper
extends CodecReader {
    private final LeafMetaData meta;
    private final CodecReader[] codecReaders;
    private final int[] docStarts;
    private final FieldInfos fieldInfos;
    private final Bits liveDocs;
    int numDocs = -1;

    static CodecReader wrap(List<CodecReader> readers) throws IOException {
        switch (readers.size()) {
            case 0: {
                throw new IllegalArgumentException("Must take at least one reader, got 0");
            }
            case 1: {
                return readers.get(0);
            }
        }
        return new SlowCompositeCodecReaderWrapper(readers);
    }

    private SlowCompositeCodecReaderWrapper(List<CodecReader> codecReaders) throws IOException {
        this.codecReaders = (CodecReader[])codecReaders.toArray(CodecReader[]::new);
        this.docStarts = new int[codecReaders.size() + 1];
        int i = 0;
        int docStart = 0;
        for (CodecReader reader : codecReaders) {
            this.docStarts[++i] = docStart += reader.maxDoc();
        }
        int majorVersion = -1;
        Version minVersion = null;
        boolean hasBlocks = false;
        for (CodecReader reader : codecReaders) {
            LeafMetaData readerMeta = reader.getMetaData();
            if (majorVersion == -1) {
                majorVersion = readerMeta.createdVersionMajor();
            } else if (majorVersion != readerMeta.createdVersionMajor()) {
                throw new IllegalArgumentException("Cannot combine leaf readers created with different major versions");
            }
            if (minVersion == null) {
                minVersion = readerMeta.minVersion();
            } else if (minVersion.onOrAfter(readerMeta.minVersion())) {
                minVersion = readerMeta.minVersion();
            }
            hasBlocks |= readerMeta.hasBlocks();
        }
        this.meta = new LeafMetaData(majorVersion, minVersion, null, hasBlocks);
        MultiReader multiReader = new MultiReader((IndexReader[])codecReaders.toArray(CodecReader[]::new));
        this.fieldInfos = FieldInfos.getMergedFieldInfos(multiReader);
        this.liveDocs = MultiBits.getLiveDocs(multiReader);
    }

    private int docIdToReaderId(int doc) {
        Objects.checkIndex(doc, this.docStarts[this.docStarts.length - 1]);
        int readerId = Arrays.binarySearch(this.docStarts, doc);
        if (readerId < 0) {
            readerId = -2 - readerId;
        }
        return readerId;
    }

    @Override
    public StoredFieldsReader getFieldsReader() {
        StoredFieldsReader[] readers = (StoredFieldsReader[])Arrays.stream(this.codecReaders).map(CodecReader::getFieldsReader).toArray(StoredFieldsReader[]::new);
        return new SlowCompositeStoredFieldsReaderWrapper(readers, this.docStarts);
    }

    private FieldInfo remap(FieldInfo info) {
        return this.fieldInfos.fieldInfo(info.name);
    }

    @Override
    public TermVectorsReader getTermVectorsReader() {
        TermVectorsReader[] readers = (TermVectorsReader[])Arrays.stream(this.codecReaders).map(CodecReader::getTermVectorsReader).toArray(TermVectorsReader[]::new);
        return new SlowCompositeTermVectorsReaderWrapper(readers, this.docStarts);
    }

    @Override
    public NormsProducer getNormsReader() {
        return new SlowCompositeNormsProducer(this.codecReaders);
    }

    @Override
    public DocValuesProducer getDocValuesReader() {
        return new SlowCompositeDocValuesProducerWrapper(this.codecReaders, this.docStarts);
    }

    @Override
    public FieldsProducer getPostingsReader() {
        FieldsProducer[] producers = (FieldsProducer[])Arrays.stream(this.codecReaders).map(CodecReader::getPostingsReader).toArray(FieldsProducer[]::new);
        return new SlowCompositeFieldsProducerWrapper(producers, this.docStarts);
    }

    @Override
    public PointsReader getPointsReader() {
        return new SlowCompositePointsReaderWrapper(this.codecReaders, this.docStarts);
    }

    @Override
    public KnnVectorsReader getVectorReader() {
        return new SlowCompositeKnnVectorsReaderWrapper(this.codecReaders, this.docStarts);
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    @Override
    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    public Bits getLiveDocs() {
        return this.liveDocs;
    }

    @Override
    public LeafMetaData getMetaData() {
        return this.meta;
    }

    @Override
    public synchronized int numDocs() {
        if (this.numDocs == -1) {
            this.numDocs = 0;
            for (CodecReader reader : this.codecReaders) {
                this.numDocs += reader.numDocs();
            }
        }
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.docStarts[this.docStarts.length - 1];
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    private class SlowCompositeStoredFieldsReaderWrapper
    extends StoredFieldsReader {
        private final StoredFieldsReader[] readers;
        private final int[] docStarts;

        SlowCompositeStoredFieldsReaderWrapper(StoredFieldsReader[] readers, int[] docStarts) {
            this.readers = readers;
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.readers);
        }

        @Override
        public StoredFieldsReader clone() {
            return new SlowCompositeStoredFieldsReaderWrapper((StoredFieldsReader[])Arrays.stream(this.readers).map(StoredFieldsReader::clone).toArray(StoredFieldsReader[]::new), this.docStarts);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (StoredFieldsReader reader : this.readers) {
                if (reader == null) continue;
                reader.checkIntegrity();
            }
        }

        @Override
        public void prefetch(int docID) throws IOException {
            int readerId = SlowCompositeCodecReaderWrapper.this.docIdToReaderId(docID);
            this.readers[readerId].prefetch(docID - this.docStarts[readerId]);
        }

        @Override
        public void document(int docID, final StoredFieldVisitor visitor) throws IOException {
            int readerId = SlowCompositeCodecReaderWrapper.this.docIdToReaderId(docID);
            this.readers[readerId].document(docID - this.docStarts[readerId], new StoredFieldVisitor(){

                @Override
                public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                    return visitor.needsField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo));
                }

                @Override
                public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
                    visitor.binaryField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void stringField(FieldInfo fieldInfo, String value) throws IOException {
                    visitor.stringField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void intField(FieldInfo fieldInfo, int value) throws IOException {
                    visitor.intField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void longField(FieldInfo fieldInfo, long value) throws IOException {
                    visitor.longField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void floatField(FieldInfo fieldInfo, float value) throws IOException {
                    visitor.floatField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
                    visitor.doubleField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }
            });
        }
    }

    private class SlowCompositeTermVectorsReaderWrapper
    extends TermVectorsReader {
        private final TermVectorsReader[] readers;
        private final int[] docStarts;

        SlowCompositeTermVectorsReaderWrapper(TermVectorsReader[] readers, int[] docStarts) {
            this.readers = readers;
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.readers);
        }

        @Override
        public TermVectorsReader clone() {
            return new SlowCompositeTermVectorsReaderWrapper((TermVectorsReader[])Arrays.stream(this.readers).map(TermVectorsReader::clone).toArray(TermVectorsReader[]::new), this.docStarts);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (TermVectorsReader reader : this.readers) {
                if (reader == null) continue;
                reader.checkIntegrity();
            }
        }

        @Override
        public void prefetch(int doc) throws IOException {
            int readerId = SlowCompositeCodecReaderWrapper.this.docIdToReaderId(doc);
            TermVectorsReader reader = this.readers[readerId];
            if (reader != null) {
                reader.prefetch(doc - this.docStarts[readerId]);
            }
        }

        @Override
        public Fields get(int doc) throws IOException {
            int readerId = SlowCompositeCodecReaderWrapper.this.docIdToReaderId(doc);
            TermVectorsReader reader = this.readers[readerId];
            if (reader == null) {
                return null;
            }
            return reader.get(doc - this.docStarts[readerId]);
        }
    }

    private static class SlowCompositeNormsProducer
    extends NormsProducer {
        private final CodecReader[] codecReaders;
        private final NormsProducer[] producers;

        SlowCompositeNormsProducer(CodecReader[] codecReaders) {
            this.codecReaders = codecReaders;
            this.producers = (NormsProducer[])Arrays.stream(codecReaders).map(CodecReader::getNormsReader).toArray(NormsProducer[]::new);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.producers);
        }

        @Override
        public NumericDocValues getNorms(FieldInfo field2) throws IOException {
            return MultiDocValues.getNormValues(new MultiReader((IndexReader[])this.codecReaders), field2.name);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (NormsProducer producer : this.producers) {
                if (producer == null) continue;
                producer.checkIntegrity();
            }
        }
    }

    private static class SlowCompositeDocValuesProducerWrapper
    extends DocValuesProducer {
        private final CodecReader[] codecReaders;
        private final DocValuesProducer[] producers;
        private final int[] docStarts;
        private final Map<String, OrdinalMap> cachedOrdMaps = new HashMap<String, OrdinalMap>();

        SlowCompositeDocValuesProducerWrapper(CodecReader[] codecReaders, int[] docStarts) {
            this.codecReaders = codecReaders;
            this.producers = (DocValuesProducer[])Arrays.stream(codecReaders).map(CodecReader::getDocValuesReader).toArray(DocValuesProducer[]::new);
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.producers);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (DocValuesProducer producer : this.producers) {
                if (producer == null) continue;
                producer.checkIntegrity();
            }
        }

        @Override
        public NumericDocValues getNumeric(FieldInfo field2) throws IOException {
            return MultiDocValues.getNumericValues(new MultiReader((IndexReader[])this.codecReaders), field2.name);
        }

        @Override
        public BinaryDocValues getBinary(FieldInfo field2) throws IOException {
            return MultiDocValues.getBinaryValues(new MultiReader((IndexReader[])this.codecReaders), field2.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedDocValues getSorted(FieldInfo field2) throws IOException {
            OrdinalMap map = null;
            Map<String, OrdinalMap> map2 = this.cachedOrdMaps;
            synchronized (map2) {
                map = this.cachedOrdMaps.get(field2.name);
                if (map == null) {
                    SortedDocValues dv = MultiDocValues.getSortedValues(new MultiReader((IndexReader[])this.codecReaders), field2.name);
                    if (dv instanceof MultiDocValues.MultiSortedDocValues) {
                        map = ((MultiDocValues.MultiSortedDocValues)dv).mapping;
                        this.cachedOrdMaps.put(field2.name, map);
                    }
                    return dv;
                }
            }
            int size = this.codecReaders.length;
            SortedDocValues[] values = new SortedDocValues[size];
            long totalCost = 0L;
            for (int i = 0; i < size; ++i) {
                CodecReader reader = this.codecReaders[i];
                SortedDocValues v = ((LeafReader)reader).getSortedDocValues(field2.name);
                if (v == null) {
                    v = DocValues.emptySorted();
                }
                values[i] = v;
                totalCost += v.cost();
            }
            return new MultiDocValues.MultiSortedDocValues(values, this.docStarts, map, totalCost);
        }

        @Override
        public SortedNumericDocValues getSortedNumeric(FieldInfo field2) throws IOException {
            return MultiDocValues.getSortedNumericValues(new MultiReader((IndexReader[])this.codecReaders), field2.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSetDocValues getSortedSet(FieldInfo field2) throws IOException {
            OrdinalMap map = null;
            Map<String, OrdinalMap> map2 = this.cachedOrdMaps;
            synchronized (map2) {
                map = this.cachedOrdMaps.get(field2.name);
                if (map == null) {
                    SortedSetDocValues dv = MultiDocValues.getSortedSetValues(new MultiReader((IndexReader[])this.codecReaders), field2.name);
                    if (dv instanceof MultiDocValues.MultiSortedSetDocValues) {
                        map = ((MultiDocValues.MultiSortedSetDocValues)dv).mapping;
                        this.cachedOrdMaps.put(field2.name, map);
                    }
                    return dv;
                }
            }
            assert (map != null);
            int size = this.codecReaders.length;
            SortedSetDocValues[] values = new SortedSetDocValues[size];
            long totalCost = 0L;
            for (int i = 0; i < size; ++i) {
                CodecReader reader = this.codecReaders[i];
                SortedSetDocValues v = ((LeafReader)reader).getSortedSetDocValues(field2.name);
                if (v == null) {
                    v = DocValues.emptySortedSet();
                }
                values[i] = v;
                totalCost += v.cost();
            }
            return new MultiDocValues.MultiSortedSetDocValues(values, this.docStarts, map, totalCost);
        }

        @Override
        public DocValuesSkipper getSkipper(FieldInfo field2) throws IOException {
            throw new UnsupportedOperationException("This method is for searching not for merging");
        }
    }

    private static class SlowCompositeFieldsProducerWrapper
    extends FieldsProducer {
        private final FieldsProducer[] producers;
        private final MultiFields fields;

        SlowCompositeFieldsProducerWrapper(FieldsProducer[] producers, int[] docStarts) {
            this.producers = producers;
            ArrayList<FieldsProducer> subs = new ArrayList<FieldsProducer>();
            ArrayList<ReaderSlice> slices = new ArrayList<ReaderSlice>();
            int i = 0;
            for (FieldsProducer producer : producers) {
                if (producer != null) {
                    subs.add(producer);
                    slices.add(new ReaderSlice(docStarts[i], docStarts[i + 1], i));
                }
                ++i;
            }
            this.fields = new MultiFields((Fields[])subs.toArray(Fields[]::new), (ReaderSlice[])slices.toArray(ReaderSlice[]::new));
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.producers);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (FieldsProducer producer : this.producers) {
                if (producer == null) continue;
                producer.checkIntegrity();
            }
        }

        @Override
        public Iterator<String> iterator() {
            return this.fields.iterator();
        }

        @Override
        public Terms terms(String field2) throws IOException {
            return this.fields.terms(field2);
        }

        @Override
        public int size() {
            return this.fields.size();
        }
    }

    private static class SlowCompositePointsReaderWrapper
    extends PointsReader {
        private final CodecReader[] codecReaders;
        private final PointsReader[] readers;
        private final int[] docStarts;

        SlowCompositePointsReaderWrapper(CodecReader[] codecReaders, int[] docStarts) {
            this.codecReaders = codecReaders;
            this.readers = (PointsReader[])Arrays.stream(codecReaders).map(CodecReader::getPointsReader).toArray(PointsReader[]::new);
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.readers);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (PointsReader reader : this.readers) {
                if (reader == null) continue;
                reader.checkIntegrity();
            }
        }

        @Override
        public PointValues getValues(String field2) throws IOException {
            final ArrayList<PointValuesSub> values = new ArrayList<PointValuesSub>();
            for (int i = 0; i < this.readers.length; ++i) {
                PointValues v;
                FieldInfo fi = this.codecReaders[i].getFieldInfos().fieldInfo(field2);
                if (fi == null || fi.getPointDimensionCount() <= 0 || (v = this.readers[i].getValues(field2)) == null) continue;
                values.add(new PointValuesSub(v, this.docStarts[i]));
            }
            if (values.isEmpty()) {
                return null;
            }
            return new PointValues(this){

                @Override
                public PointValues.PointTree getPointTree() throws IOException {
                    return new PointValues.PointTree(){

                        @Override
                        public PointValues.PointTree clone() {
                            return this;
                        }

                        @Override
                        public void visitDocValues(PointValues.IntersectVisitor visitor) throws IOException {
                            for (PointValuesSub sub : values) {
                                sub.sub.getPointTree().visitDocValues(this.wrapIntersectVisitor(visitor, sub.docBase));
                            }
                        }

                        @Override
                        public void visitDocIDs(PointValues.IntersectVisitor visitor) throws IOException {
                            for (PointValuesSub sub : values) {
                                sub.sub.getPointTree().visitDocIDs(this.wrapIntersectVisitor(visitor, sub.docBase));
                            }
                        }

                        private PointValues.IntersectVisitor wrapIntersectVisitor(final PointValues.IntersectVisitor visitor, final int docStart) {
                            return new PointValues.IntersectVisitor(){

                                @Override
                                public void visit(int docID, byte[] packedValue) throws IOException {
                                    visitor.visit(docStart + docID, packedValue);
                                }

                                @Override
                                public void visit(int docID) throws IOException {
                                    visitor.visit(docStart + docID);
                                }

                                @Override
                                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                                    return visitor.compare(minPackedValue, maxPackedValue);
                                }
                            };
                        }

                        @Override
                        public long size() {
                            long size = 0L;
                            for (PointValuesSub sub : values) {
                                size += sub.sub.size();
                            }
                            return size;
                        }

                        @Override
                        public boolean moveToSibling() throws IOException {
                            return false;
                        }

                        @Override
                        public boolean moveToParent() throws IOException {
                            return false;
                        }

                        @Override
                        public boolean moveToChild() throws IOException {
                            return false;
                        }

                        @Override
                        public byte[] getMinPackedValue() {
                            try {
                                byte[] minPackedValue = null;
                                for (PointValuesSub sub : values) {
                                    if (minPackedValue == null) {
                                        minPackedValue = (byte[])sub.sub.getMinPackedValue().clone();
                                        continue;
                                    }
                                    byte[] leafMinPackedValue = sub.sub.getMinPackedValue();
                                    int numIndexDimensions = sub.sub.getNumIndexDimensions();
                                    int numBytesPerDimension = sub.sub.getBytesPerDimension();
                                    ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator(numBytesPerDimension);
                                    for (int i = 0; i < numIndexDimensions; ++i) {
                                        if (comparator.compare(leafMinPackedValue, i * numBytesPerDimension, minPackedValue, i * numBytesPerDimension) >= 0) continue;
                                        System.arraycopy(leafMinPackedValue, i * numBytesPerDimension, minPackedValue, i * numBytesPerDimension, numBytesPerDimension);
                                    }
                                }
                                return minPackedValue;
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }

                        @Override
                        public byte[] getMaxPackedValue() {
                            try {
                                byte[] maxPackedValue = null;
                                for (PointValuesSub sub : values) {
                                    if (maxPackedValue == null) {
                                        maxPackedValue = (byte[])sub.sub.getMaxPackedValue().clone();
                                        continue;
                                    }
                                    byte[] leafMinPackedValue = sub.sub.getMaxPackedValue();
                                    int numIndexDimensions = sub.sub.getNumIndexDimensions();
                                    int numBytesPerDimension = sub.sub.getBytesPerDimension();
                                    ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator(numBytesPerDimension);
                                    for (int i = 0; i < numIndexDimensions; ++i) {
                                        if (comparator.compare(leafMinPackedValue, i * numBytesPerDimension, maxPackedValue, i * numBytesPerDimension) <= 0) continue;
                                        System.arraycopy(leafMinPackedValue, i * numBytesPerDimension, maxPackedValue, i * numBytesPerDimension, numBytesPerDimension);
                                    }
                                }
                                return maxPackedValue;
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }
                    };
                }

                @Override
                public byte[] getMinPackedValue() throws IOException {
                    return this.getPointTree().getMinPackedValue();
                }

                @Override
                public byte[] getMaxPackedValue() throws IOException {
                    return this.getPointTree().getMaxPackedValue();
                }

                @Override
                public int getNumDimensions() throws IOException {
                    return ((PointValuesSub)values.get((int)0)).sub.getNumDimensions();
                }

                @Override
                public int getNumIndexDimensions() throws IOException {
                    return ((PointValuesSub)values.get((int)0)).sub.getNumIndexDimensions();
                }

                @Override
                public int getBytesPerDimension() throws IOException {
                    return ((PointValuesSub)values.get((int)0)).sub.getBytesPerDimension();
                }

                @Override
                public long size() {
                    try {
                        return this.getPointTree().size();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                @Override
                public int getDocCount() {
                    int docCount = 0;
                    for (PointValuesSub sub : values) {
                        docCount += sub.sub.getDocCount();
                    }
                    return docCount;
                }
            };
        }
    }

    private static class SlowCompositeKnnVectorsReaderWrapper
    extends KnnVectorsReader {
        private final CodecReader[] codecReaders;
        private final KnnVectorsReader[] readers;
        private final int[] docStarts;

        SlowCompositeKnnVectorsReaderWrapper(CodecReader[] codecReaders, int[] docStarts) {
            this.codecReaders = codecReaders;
            this.readers = (KnnVectorsReader[])Arrays.stream(codecReaders).map(CodecReader::getVectorReader).toArray(KnnVectorsReader[]::new);
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.readers);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (KnnVectorsReader reader : this.readers) {
                if (reader == null) continue;
                reader.checkIntegrity();
            }
        }

        @Override
        public FloatVectorValues getFloatVectorValues(String field2) throws IOException {
            ArrayList<DocValuesSub<FloatVectorValues>> subs = new ArrayList<DocValuesSub<FloatVectorValues>>();
            int i = 0;
            int dimension = -1;
            int size = 0;
            for (CodecReader reader : this.codecReaders) {
                FloatVectorValues values = reader.getFloatVectorValues(field2);
                subs.add(new DocValuesSub<FloatVectorValues>(values, this.docStarts[i], size));
                if (values != null) {
                    if (dimension == -1) {
                        dimension = values.dimension();
                    }
                    size += values.size();
                }
                ++i;
            }
            return new MergedFloatVectorValues(dimension, size, subs);
        }

        @Override
        public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
            Map<String, Long> map = new HashMap<String, Long>();
            for (KnnVectorsReader reader : this.readers) {
                map = KnnVectorsReader.mergeOffHeapByteSizeMaps(map, reader.getOffHeapByteSize(fieldInfo));
            }
            return map;
        }

        @Override
        public ByteVectorValues getByteVectorValues(String field2) throws IOException {
            ArrayList<DocValuesSub<ByteVectorValues>> subs = new ArrayList<DocValuesSub<ByteVectorValues>>();
            int i = 0;
            int dimension = -1;
            int size = 0;
            for (CodecReader reader : this.codecReaders) {
                ByteVectorValues values = reader.getByteVectorValues(field2);
                subs.add(new DocValuesSub<ByteVectorValues>(values, this.docStarts[i], size));
                if (values != null) {
                    if (dimension == -1) {
                        dimension = values.dimension();
                    }
                    size += values.size();
                }
                ++i;
            }
            return new MergedByteVectorValues(dimension, size, subs);
        }

        private static int findSub(int ord, int lastSubIndex, int[] starts) {
            if (ord >= starts[lastSubIndex]) {
                if (ord >= starts[lastSubIndex + 1]) {
                    return SlowCompositeKnnVectorsReaderWrapper.binarySearchStarts(starts, ord, lastSubIndex + 1, starts.length);
                }
            } else {
                return SlowCompositeKnnVectorsReaderWrapper.binarySearchStarts(starts, ord, 0, lastSubIndex);
            }
            return lastSubIndex;
        }

        private static int binarySearchStarts(int[] starts, int ord, int from, int to) {
            int pos = Arrays.binarySearch(starts, from, to, ord);
            if (pos < 0) {
                return -2 - pos;
            }
            while (pos < starts.length - 1 && starts[pos + 1] == ord) {
                ++pos;
            }
            return pos;
        }

        @Override
        public void search(String field2, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void search(String field2, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
            throw new UnsupportedOperationException();
        }

        class MergedFloatVectorValues
        extends FloatVectorValues {
            final int dimension;
            final int size;
            final List<DocValuesSub<FloatVectorValues>> subs;
            final MergedDocIterator<FloatVectorValues> iter;
            final int[] starts;
            int lastSubIndex;

            MergedFloatVectorValues(int dimension, int size, List<DocValuesSub<FloatVectorValues>> subs) {
                this.dimension = dimension;
                this.size = size;
                this.subs = subs;
                this.iter = new MergedDocIterator(subs);
                this.starts = new int[subs.size() + 1];
                for (int i = 0; i < subs.size(); ++i) {
                    this.starts[i] = subs.get((int)i).ordStart;
                }
                this.starts[this.starts.length - 1] = size;
            }

            @Override
            public MergedDocIterator<FloatVectorValues> iterator() {
                return this.iter;
            }

            @Override
            public int dimension() {
                return this.dimension;
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public FloatVectorValues copy() throws IOException {
                ArrayList<DocValuesSub<FloatVectorValues>> subsCopy = new ArrayList<DocValuesSub<FloatVectorValues>>();
                for (DocValuesSub<FloatVectorValues> sub : this.subs) {
                    subsCopy.add(sub.copy());
                }
                return new MergedFloatVectorValues(this.dimension, this.size, subsCopy);
            }

            @Override
            public float[] vectorValue(int ord) throws IOException {
                assert (ord >= 0 && ord < this.size);
                this.lastSubIndex = SlowCompositeKnnVectorsReaderWrapper.findSub(ord, this.lastSubIndex, this.starts);
                DocValuesSub<FloatVectorValues> sub = this.subs.get(this.lastSubIndex);
                assert (sub.sub != null);
                return ((FloatVectorValues)sub.sub).vectorValue(ord - sub.ordStart);
            }
        }

        class MergedByteVectorValues
        extends ByteVectorValues {
            final int dimension;
            final int size;
            final List<DocValuesSub<ByteVectorValues>> subs;
            final MergedDocIterator<ByteVectorValues> iter;
            final int[] starts;
            int lastSubIndex;

            MergedByteVectorValues(int dimension, int size, List<DocValuesSub<ByteVectorValues>> subs) {
                this.dimension = dimension;
                this.size = size;
                this.subs = subs;
                this.iter = new MergedDocIterator(subs);
                this.starts = new int[subs.size() + 1];
                for (int i = 0; i < subs.size(); ++i) {
                    this.starts[i] = subs.get((int)i).ordStart;
                }
                this.starts[this.starts.length - 1] = size;
            }

            @Override
            public MergedDocIterator<ByteVectorValues> iterator() {
                return this.iter;
            }

            @Override
            public int dimension() {
                return this.dimension;
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public byte[] vectorValue(int ord) throws IOException {
                assert (ord >= 0 && ord < this.size);
                this.lastSubIndex = SlowCompositeKnnVectorsReaderWrapper.findSub(ord, this.lastSubIndex, this.starts);
                DocValuesSub<ByteVectorValues> sub = this.subs.get(this.lastSubIndex);
                return ((ByteVectorValues)sub.sub).vectorValue(ord - sub.ordStart);
            }

            @Override
            public ByteVectorValues copy() throws IOException {
                ArrayList<DocValuesSub<ByteVectorValues>> newSubs = new ArrayList<DocValuesSub<ByteVectorValues>>();
                for (DocValuesSub<ByteVectorValues> sub : this.subs) {
                    newSubs.add(sub.copy());
                }
                return new MergedByteVectorValues(this.dimension, this.size, newSubs);
            }
        }
    }

    private record PointValuesSub(PointValues sub, int docBase) {
        private PointValuesSub(PointValues sub, int docBase) {
            this.sub = Objects.requireNonNull(sub);
            this.docBase = docBase;
        }
    }

    private static class MergedDocIterator<T extends KnnVectorValues>
    extends KnnVectorValues.DocIndexIterator {
        final Iterator<DocValuesSub<T>> it;
        DocValuesSub<T> current;
        KnnVectorValues.DocIndexIterator currentIterator;
        int ord = -1;
        int doc = -1;

        MergedDocIterator(List<DocValuesSub<T>> subs) {
            this.it = subs.iterator();
            this.current = this.it.next();
            this.currentIterator = this.currentIterator();
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int index() {
            return this.ord;
        }

        @Override
        public int nextDoc() throws IOException {
            while (true) {
                int next;
                if (this.current.sub != null && (next = this.currentIterator.nextDoc()) != Integer.MAX_VALUE) {
                    ++this.ord;
                    this.doc = this.current.docStart + next;
                    return this.doc;
                }
                if (!this.it.hasNext()) {
                    this.ord = Integer.MAX_VALUE;
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.current = this.it.next();
                this.currentIterator = this.currentIterator();
                this.ord = this.current.ordStart - 1;
            }
        }

        private KnnVectorValues.DocIndexIterator currentIterator() {
            if (this.current.sub != null) {
                return ((KnnVectorValues)this.current.sub).iterator();
            }
            return null;
        }

        @Override
        public long cost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private record DocValuesSub<T extends KnnVectorValues>(T sub, int docStart, int ordStart) {
        DocValuesSub<T> copy() throws IOException {
            return new DocValuesSub<KnnVectorValues>(((KnnVectorValues)this.sub).copy(), this.docStart, this.ordStart);
        }
    }
}

