/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatches;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.queries.intervals.IntervalQuery;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.QueryVisitor;

abstract class DifferenceIntervalsSource
extends IntervalsSource {
    final IntervalsSource minuend;
    final IntervalsSource subtrahend;

    DifferenceIntervalsSource(IntervalsSource minuend, IntervalsSource subtrahend) {
        this.minuend = minuend;
        this.subtrahend = subtrahend;
    }

    protected abstract IntervalIterator combine(IntervalIterator var1, IntervalIterator var2);

    @Override
    public final IntervalIterator intervals(String field2, LeafReaderContext ctx) throws IOException {
        IntervalIterator minIt = this.minuend.intervals(field2, ctx);
        if (minIt == null) {
            return null;
        }
        IntervalIterator subIt = this.subtrahend.intervals(field2, ctx);
        if (subIt == null) {
            return minIt;
        }
        return this.combine(minIt, subIt);
    }

    @Override
    public final IntervalMatchesIterator matches(String field2, LeafReaderContext ctx, int doc) throws IOException {
        IntervalMatchesIterator minIt = this.minuend.matches(field2, ctx, doc);
        if (minIt == null) {
            return null;
        }
        IntervalMatchesIterator subIt = this.subtrahend.matches(field2, ctx, doc);
        if (subIt == null) {
            return minIt;
        }
        IntervalIterator difference = this.combine(IntervalMatches.wrapMatches(minIt, doc), IntervalMatches.wrapMatches(subIt, doc));
        return IntervalMatches.asMatches(difference, minIt, doc);
    }

    @Override
    public void visit(String field2, QueryVisitor visitor) {
        IntervalQuery q = new IntervalQuery(field2, this);
        this.minuend.visit(field2, visitor.getSubVisitor(BooleanClause.Occur.MUST, q));
        this.subtrahend.visit(field2, visitor.getSubVisitor(BooleanClause.Occur.MUST_NOT, q));
    }

    @Override
    public int minExtent() {
        return this.minuend.minExtent();
    }
}

