/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn;

import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;
import org.apache.lucene.util.BytesRef;

public class Wildcard
extends IntervalFunction {
    private final String wildcard;
    private final int maxExpansions;

    public Wildcard(String wildcard, int maxExpansions) {
        this.wildcard = wildcard;
        this.maxExpansions = maxExpansions;
    }

    @Override
    public IntervalsSource toIntervalSource(String field2, Analyzer analyzer) {
        if (this.maxExpansions == 0) {
            return Intervals.wildcard(new BytesRef(this.wildcard));
        }
        return Intervals.wildcard(new BytesRef(this.wildcard), this.maxExpansions);
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:wildcard(%s%s)", this.wildcard, this.maxExpansions == 0 ? "" : " maxExpansions:" + this.maxExpansions);
    }
}

