/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.comparators;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocValuesRangeIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.comparators.UpdateableDocIdSetIterator;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.IntsRef;

public abstract class NumericComparator<T extends Number>
extends FieldComparator<T> {
    private static final int MIN_SKIP_INTERVAL = 32;
    private static final int MAX_SKIP_INTERVAL = 8192;
    protected final T missingValue;
    private final long missingValueAsLong;
    protected final String field;
    protected final boolean reverse;
    private final int bytesCount;
    protected boolean topValueSet;
    protected boolean singleSort;
    protected boolean hitsThresholdReached;
    protected boolean queueFull;
    protected Pruning pruning;

    protected NumericComparator(String field2, T missingValue, boolean reverse, Pruning pruning, int bytesCount) {
        this.field = field2;
        this.missingValue = missingValue;
        this.missingValueAsLong = this.missingValueAsComparableLong();
        this.reverse = reverse;
        this.pruning = pruning;
        this.bytesCount = bytesCount;
    }

    @Override
    public void setTopValue(T value) {
        this.topValueSet = true;
    }

    @Override
    public void setSingleSort() {
        this.singleSort = true;
    }

    @Override
    public void disableSkipping() {
        this.pruning = Pruning.NONE;
    }

    protected abstract long missingValueAsComparableLong();

    protected abstract long sortableBytesToLong(byte[] var1);

    private class DVSkipperCompetitiveDISIBuilder
    extends CompetitiveDISIBuilder {
        private final DocValuesSkipper skipper;
        private final TwoPhaseIterator innerTwoPhase;

        public DVSkipperCompetitiveDISIBuilder(final NumericComparator numericComparator, DocValuesSkipper skipper, NumericLeafComparator leafComparator) throws IOException {
            super(leafComparator);
            this.skipper = skipper;
            final NumericDocValues docValues = leafComparator.getNumericDocValues(leafComparator.context, numericComparator.field);
            this.innerTwoPhase = new TwoPhaseIterator(docValues){

                @Override
                public boolean matches() throws IOException {
                    long value = docValues.longValue();
                    return value >= DVSkipperCompetitiveDISIBuilder.this.minValueAsLong && value <= DVSkipperCompetitiveDISIBuilder.this.maxValueAsLong;
                }

                @Override
                public float matchCost() {
                    return 2.0f;
                }
            };
        }

        @Override
        int docCount() {
            return this.skipper.docCount();
        }

        @Override
        void doUpdateCompetitiveIterator() {
            DocValuesRangeIterator twoPhaseIterator = new DocValuesRangeIterator(this.innerTwoPhase, this.skipper, this.minValueAsLong, this.maxValueAsLong, false);
            this.competitiveIterator.update(TwoPhaseIterator.asDocIdSetIterator(twoPhaseIterator));
        }
    }

    private class PointsCompetitiveDISIBuilder
    extends CompetitiveDISIBuilder {
        private final PointValues pointValues;
        private PointValues.PointTree pointTree;
        private long iteratorCost;
        private int tryUpdateFailCount;

        public PointsCompetitiveDISIBuilder(PointValues pointValues, NumericLeafComparator comparator) {
            super(comparator);
            this.iteratorCost = -1L;
            this.tryUpdateFailCount = 0;
            LeafReaderContext context = comparator.context;
            FieldInfo info = context.reader().getFieldInfos().fieldInfo(NumericComparator.this.field);
            if (info == null || info.getPointDimensionCount() == 0) {
                throw new IllegalStateException("Field " + NumericComparator.this.field + " doesn't index points according to FieldInfos yet returns non-null PointValues");
            }
            if (info.getPointDimensionCount() > 1) {
                throw new IllegalArgumentException("Field " + NumericComparator.this.field + " is indexed with multiple dimensions, sorting is not supported");
            }
            if (info.getPointNumBytes() != NumericComparator.this.bytesCount) {
                throw new IllegalArgumentException("Field " + NumericComparator.this.field + " is indexed with " + info.getPointNumBytes() + " bytes per dimension, but " + String.valueOf(NumericComparator.this) + " expected " + NumericComparator.this.bytesCount);
            }
            this.pointValues = pointValues;
        }

        @Override
        void setScorer(Scorable scorer) throws IOException {
            if (this.iteratorCost == -1L) {
                this.iteratorCost = scorer instanceof Scorer ? ((Scorer)scorer).iterator().cost() : (long)this.maxDoc;
                this.updateCompetitiveIterator();
            }
        }

        @Override
        int docCount() {
            return this.pointValues.getDocCount();
        }

        @Override
        void doUpdateCompetitiveIterator() throws IOException {
            final DocIdSetBuilder result = new DocIdSetBuilder(this.maxDoc);
            PointValues.IntersectVisitor visitor = new PointValues.IntersectVisitor(){
                DocIdSetBuilder.BulkAdder adder;

                @Override
                public void grow(int count) {
                    this.adder = result.grow(count);
                }

                @Override
                public void visit(int docID) {
                    if (docID <= PointsCompetitiveDISIBuilder.this.maxDocVisited) {
                        return;
                    }
                    this.adder.add(docID);
                }

                @Override
                public void visit(int docID, byte[] packedValue) {
                    if (docID <= PointsCompetitiveDISIBuilder.this.maxDocVisited) {
                        return;
                    }
                    long l = NumericComparator.this.sortableBytesToLong(packedValue);
                    if (l >= PointsCompetitiveDISIBuilder.this.minValueAsLong && l <= PointsCompetitiveDISIBuilder.this.maxValueAsLong) {
                        this.adder.add(docID);
                    }
                }

                @Override
                public void visit(DocIdSetIterator iterator) throws IOException {
                    if (iterator.advance(PointsCompetitiveDISIBuilder.this.maxDocVisited + 1) != Integer.MAX_VALUE) {
                        this.adder.add(iterator.docID());
                        this.adder.add(iterator);
                    }
                }

                @Override
                public void visit(IntsRef ref) {
                    this.adder.add(ref, PointsCompetitiveDISIBuilder.this.maxDocVisited + 1);
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    long min = NumericComparator.this.sortableBytesToLong(minPackedValue);
                    long max = NumericComparator.this.sortableBytesToLong(maxPackedValue);
                    if (min > PointsCompetitiveDISIBuilder.this.maxValueAsLong || max < PointsCompetitiveDISIBuilder.this.minValueAsLong) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    if (min < PointsCompetitiveDISIBuilder.this.minValueAsLong || max > PointsCompetitiveDISIBuilder.this.maxValueAsLong) {
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            };
            long threshold = this.iteratorCost >>> 3;
            if (PointValues.isEstimatedPointCountGreaterThanOrEqualTo(visitor, this.getPointTree(), threshold)) {
                this.updateSkipInterval(false);
                if ((long)this.pointValues.getDocCount() < this.iteratorCost) {
                    this.competitiveIterator.update(this.leafComparator.getNumericDocValues(this.leafComparator.context, NumericComparator.this.field));
                    this.iteratorCost = this.pointValues.getDocCount();
                }
                return;
            }
            this.pointValues.intersect(visitor);
            this.competitiveIterator.update(result.build().iterator());
            this.iteratorCost = this.competitiveIterator.cost();
            this.updateSkipInterval(true);
        }

        private PointValues.PointTree getPointTree() throws IOException {
            if (this.pointTree == null) {
                this.pointTree = this.pointValues.getPointTree();
            }
            return this.pointTree;
        }

        private void updateSkipInterval(boolean success) {
            if (this.updateCounter > 256) {
                if (success) {
                    this.currentSkipInterval = Math.max(this.currentSkipInterval / 2, 32);
                    this.tryUpdateFailCount = 0;
                } else if (this.tryUpdateFailCount >= 3) {
                    this.currentSkipInterval = Math.min(this.currentSkipInterval * 2, 8192);
                    this.tryUpdateFailCount = 0;
                } else {
                    ++this.tryUpdateFailCount;
                }
            }
        }
    }

    private abstract class CompetitiveDISIBuilder {
        final int maxDoc;
        final NumericLeafComparator leafComparator;
        final boolean leafTopSet;
        final UpdateableDocIdSetIterator competitiveIterator;
        long minValueAsLong;
        long maxValueAsLong;
        int maxDocVisited;
        int updateCounter;
        int currentSkipInterval;

        CompetitiveDISIBuilder(NumericLeafComparator leafComparator) {
            this.leafTopSet = NumericComparator.this.topValueSet;
            this.competitiveIterator = new UpdateableDocIdSetIterator();
            this.minValueAsLong = Long.MIN_VALUE;
            this.maxValueAsLong = Long.MAX_VALUE;
            this.maxDocVisited = -1;
            this.updateCounter = 0;
            this.currentSkipInterval = 32;
            this.leafComparator = leafComparator;
            this.maxDoc = leafComparator.context.reader().maxDoc();
            this.competitiveIterator.update(DocIdSetIterator.all(this.maxDoc));
            if (this.leafTopSet) {
                this.encodeTop();
            }
        }

        void setScorer(Scorable scorer) throws IOException {
        }

        abstract int docCount();

        final void updateCompetitiveIterator() throws IOException {
            if (!NumericComparator.this.hitsThresholdReached) {
                return;
            }
            if (!this.leafTopSet && !NumericComparator.this.queueFull) {
                return;
            }
            if (this.docCount() < this.maxDoc && this.isMissingValueCompetitive()) {
                return;
            }
            ++this.updateCounter;
            if (this.updateCounter > 256 && (this.updateCounter & this.currentSkipInterval - 1) != this.currentSkipInterval - 1) {
                return;
            }
            if (NumericComparator.this.queueFull) {
                this.encodeBottom();
            }
            this.doUpdateCompetitiveIterator();
        }

        abstract void doUpdateCompetitiveIterator() throws IOException;

        private void setMaxDocVisited(int maxDocVisited) {
            this.maxDocVisited = maxDocVisited;
        }

        private void encodeBottom() {
            if (!NumericComparator.this.reverse) {
                this.maxValueAsLong = this.leafComparator.bottomAsComparableLong();
                if (NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO && this.maxValueAsLong != Long.MIN_VALUE) {
                    --this.maxValueAsLong;
                }
            } else {
                this.minValueAsLong = this.leafComparator.bottomAsComparableLong();
                if (NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO && this.minValueAsLong != Long.MAX_VALUE) {
                    ++this.minValueAsLong;
                }
            }
        }

        private void encodeTop() {
            if (!NumericComparator.this.reverse) {
                this.minValueAsLong = this.leafComparator.topAsComparableLong();
                if (NumericComparator.this.singleSort && NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO && NumericComparator.this.queueFull && this.minValueAsLong != Long.MAX_VALUE) {
                    ++this.minValueAsLong;
                }
            } else {
                this.maxValueAsLong = this.leafComparator.topAsComparableLong();
                if (NumericComparator.this.singleSort && NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO && NumericComparator.this.queueFull && this.maxValueAsLong != Long.MIN_VALUE) {
                    --this.maxValueAsLong;
                }
            }
        }

        boolean isMissingValueCompetitive() {
            int result;
            if (NumericComparator.this.queueFull) {
                boolean competitive;
                result = Long.compare(NumericComparator.this.missingValueAsLong, this.leafComparator.bottomAsComparableLong());
                boolean bl = NumericComparator.this.reverse ? (NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO ? result > 0 : result >= 0) : (NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO ? result < 0 : (competitive = result <= 0));
                if (!competitive) {
                    return false;
                }
            }
            if (this.leafTopSet) {
                result = Long.compare(NumericComparator.this.missingValueAsLong, this.leafComparator.topAsComparableLong());
                return NumericComparator.this.reverse ? result <= 0 : result >= 0;
            }
            return true;
        }
    }

    public abstract class NumericLeafComparator
    implements LeafFieldComparator {
        private final LeafReaderContext context;
        protected final NumericDocValues docValues;
        private final CompetitiveDISIBuilder competitiveDISIBuilder;

        public NumericLeafComparator(LeafReaderContext context) throws IOException {
            this.context = context;
            this.docValues = this.getNumericDocValues(context, NumericComparator.this.field);
            CompetitiveDISIBuilder builder = null;
            if (NumericComparator.this.pruning != Pruning.NONE) {
                LeafReader reader = context.reader();
                PointValues pointValues = reader.getPointValues(NumericComparator.this.field);
                if (pointValues != null) {
                    builder = new PointsCompetitiveDISIBuilder(pointValues, this);
                } else {
                    DocValuesSkipper skipper = reader.getDocValuesSkipper(NumericComparator.this.field);
                    if (skipper != null) {
                        builder = new DVSkipperCompetitiveDISIBuilder(NumericComparator.this, skipper, this);
                    }
                }
            }
            this.competitiveDISIBuilder = builder;
        }

        protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field2) throws IOException {
            return DocValues.getNumeric(context.reader(), field2);
        }

        @Override
        public void setBottom(int slot) throws IOException {
            NumericComparator.this.queueFull = true;
            if (this.competitiveDISIBuilder != null) {
                this.competitiveDISIBuilder.updateCompetitiveIterator();
            }
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            if (this.competitiveDISIBuilder != null) {
                this.competitiveDISIBuilder.setMaxDocVisited(doc);
            }
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            if (this.competitiveDISIBuilder != null) {
                this.competitiveDISIBuilder.setScorer(scorer);
            }
        }

        @Override
        public void setHitsThresholdReached() throws IOException {
            NumericComparator.this.hitsThresholdReached = true;
            if (this.competitiveDISIBuilder != null) {
                this.competitiveDISIBuilder.updateCompetitiveIterator();
            }
        }

        @Override
        public DocIdSetIterator competitiveIterator() {
            return this.competitiveDISIBuilder == null ? null : this.competitiveDISIBuilder.competitiveIterator;
        }

        protected abstract long bottomAsComparableLong();

        protected abstract long topAsComparableLong();
    }
}

