/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.message2;

import com.ibm.icu.math.BigDecimal;
import com.ibm.icu.message2.Directionality;
import com.ibm.icu.message2.FormattedPlaceholder;
import com.ibm.icu.message2.Function;
import com.ibm.icu.message2.FunctionFactory;
import com.ibm.icu.message2.MFDataModel;
import com.ibm.icu.message2.OptUtils;
import com.ibm.icu.message2.PlainStringFormattedValue;
import com.ibm.icu.number.FormattedNumber;
import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.Notation;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.Precision;
import com.ibm.icu.number.UnlocalizedNumberFormatter;
import com.ibm.icu.text.FormattedValue;
import com.ibm.icu.text.NumberingSystem;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.CurrencyAmount;
import com.ibm.icu.util.NoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

class NumberFunctionFactory
implements FunctionFactory {
    private final String kind;
    private static final Pattern CURRENCY_ISO_CODE = Pattern.compile("^[A-Z][A-Z][A-Z]$", 2);

    public NumberFunctionFactory(String kind) {
        switch (kind) {
            case "number": 
            case "integer": 
            case "currency": 
            case "percent": 
            case "offset": {
                break;
            }
            default: {
                kind = "number";
            }
        }
        this.kind = kind;
    }

    @Override
    public Function create(Locale locale, Map<String, Object> fixedOptions) {
        PluralRules.PluralType pluralType;
        String type;
        boolean reportErrors = OptUtils.reportErrors(fixedOptions);
        switch (type = OptUtils.getString(fixedOptions, "select", "")) {
            case "exact": {
                pluralType = null;
                break;
            }
            case "ordinal": {
                pluralType = PluralRules.PluralType.ORDINAL;
                break;
            }
            case "": 
            case "cardinal": {
                pluralType = PluralRules.PluralType.CARDINAL;
                break;
            }
            default: {
                if (reportErrors) {
                    throw new IllegalArgumentException("bad-option: invalid value `" + type + "` for `select`.");
                }
                pluralType = PluralRules.PluralType.CARDINAL;
            }
        }
        PluralRules rules = pluralType == null ? null : PluralRules.forLocale(locale, pluralType);
        return new NumberFunctionImpl(locale, rules, fixedOptions, this.kind);
    }

    private static LocalizedNumberFormatter functionForOptions(Locale locale, Map<String, Object> fixedOptions, String kind) {
        NumberFormatter.GroupingStrategy grp;
        NumberFormatter.SignDisplay signDisplay;
        Integer option;
        String strOption;
        boolean reportErrors = OptUtils.reportErrors(fixedOptions);
        String skeleton = OptUtils.getString(fixedOptions, "icu:skeleton");
        if (skeleton != null) {
            return NumberFormatter.forSkeleton(skeleton).locale(locale);
        }
        UnlocalizedNumberFormatter nf = NumberFormatter.with();
        if (Objects.equals(kind, "number")) {
            Notation notation;
            block6 : switch (OptUtils.getString(fixedOptions, "notation", "standard")) {
                case "scientific": {
                    notation = Notation.scientific();
                    break;
                }
                case "engineering": {
                    notation = Notation.engineering();
                    break;
                }
                case "compact": {
                    switch (OptUtils.getString(fixedOptions, "compactDisplay", "short")) {
                        case "long": {
                            notation = Notation.compactLong();
                            break block6;
                        }
                    }
                    notation = Notation.compactShort();
                    break;
                }
                default: {
                    notation = Notation.simple();
                }
            }
            nf = (UnlocalizedNumberFormatter)nf.notation(notation);
            strOption = OptUtils.getString(fixedOptions, "style", "decimal");
            option = OptUtils.getInteger(fixedOptions, reportErrors, "minimumFractionDigits");
            if (option != null) {
                nf = (UnlocalizedNumberFormatter)nf.precision(Precision.minFraction(option));
            }
            if ((option = OptUtils.getInteger(fixedOptions, reportErrors, "maximumFractionDigits")) != null) {
                nf = (UnlocalizedNumberFormatter)nf.precision(Precision.maxFraction(option));
            }
            if ((option = OptUtils.getInteger(fixedOptions, reportErrors, "minimumSignificantDigits")) != null) {
                nf = (UnlocalizedNumberFormatter)nf.precision(Precision.minSignificantDigits(option));
            }
        }
        if (!(strOption = OptUtils.getString(fixedOptions, "numberingSystem", "")).isEmpty()) {
            strOption = strOption.toLowerCase(Locale.US);
            NumberingSystem ns = NumberingSystem.getInstanceByName(strOption);
            nf = (UnlocalizedNumberFormatter)nf.symbols(ns);
        }
        if ((option = OptUtils.getInteger(fixedOptions, reportErrors, "minimumIntegerDigits")) != null) {
            // empty if block
        }
        if ((option = OptUtils.getInteger(fixedOptions, reportErrors, "maximumSignificantDigits")) != null) {
            nf = (UnlocalizedNumberFormatter)nf.precision(Precision.maxSignificantDigits(option));
        }
        switch (strOption = OptUtils.getString(fixedOptions, "signDisplay", "auto")) {
            case "always": {
                signDisplay = NumberFormatter.SignDisplay.ALWAYS;
                break;
            }
            case "exceptZero": {
                signDisplay = NumberFormatter.SignDisplay.EXCEPT_ZERO;
                break;
            }
            case "negative": {
                signDisplay = NumberFormatter.SignDisplay.NEGATIVE;
                break;
            }
            case "never": {
                signDisplay = NumberFormatter.SignDisplay.NEVER;
                break;
            }
            default: {
                signDisplay = NumberFormatter.SignDisplay.AUTO;
            }
        }
        nf = (UnlocalizedNumberFormatter)nf.sign(signDisplay);
        switch (strOption = OptUtils.getString(fixedOptions, "useGrouping", "auto")) {
            case "always": {
                grp = NumberFormatter.GroupingStrategy.ON_ALIGNED;
                break;
            }
            case "never": {
                grp = NumberFormatter.GroupingStrategy.OFF;
                break;
            }
            case "min2": {
                grp = NumberFormatter.GroupingStrategy.MIN2;
                break;
            }
            default: {
                grp = NumberFormatter.GroupingStrategy.AUTO;
            }
        }
        nf = (UnlocalizedNumberFormatter)nf.grouping(grp);
        if (kind.equals("integer")) {
            nf = (UnlocalizedNumberFormatter)nf.precision(Precision.integer());
        }
        if (kind.equals("currency")) {
            NumberFormatter.UnitWidth width;
            strOption = NumberFunctionFactory.getCurrency(fixedOptions);
            if (strOption != null) {
                nf = (UnlocalizedNumberFormatter)nf.unit(Currency.getInstance(strOption));
            }
            switch (strOption = OptUtils.getString(fixedOptions, "currencySign", "standard")) {
                default: 
            }
            switch (strOption = OptUtils.getString(fixedOptions, "currencyDisplay", "symbol")) {
                case "narrowSymbol": {
                    width = NumberFormatter.UnitWidth.NARROW;
                    break;
                }
                case "symbol": {
                    width = NumberFormatter.UnitWidth.SHORT;
                    break;
                }
                case "name": {
                    width = NumberFormatter.UnitWidth.FULL_NAME;
                    break;
                }
                case "code": {
                    width = NumberFormatter.UnitWidth.ISO_CODE;
                    break;
                }
                case "formalSymbol": {
                    width = NumberFormatter.UnitWidth.FORMAL;
                    break;
                }
                case "never": {
                    width = NumberFormatter.UnitWidth.HIDDEN;
                    break;
                }
                default: {
                    width = NumberFormatter.UnitWidth.SHORT;
                }
            }
            nf = (UnlocalizedNumberFormatter)nf.unitWidth(width);
        }
        if (kind.equals("percent")) {
            nf = (UnlocalizedNumberFormatter)nf.unit(NoUnit.PERCENT);
        }
        return nf.locale(locale);
    }

    static String getCurrency(Map<String, Object> options) {
        String value = OptUtils.getString(options, "currency", null);
        if (value != null) {
            if (CURRENCY_ISO_CODE.matcher(value).find()) {
                return value;
            }
            if (OptUtils.reportErrors(options)) {
                throw new IllegalArgumentException("bad-option: the `currency` must be an ISO 4217 code.");
            }
        }
        return null;
    }

    private static class ResolvedOffsetOptions {
        final int operand;
        final boolean reportErrors;

        ResolvedOffsetOptions(int operand, boolean reportErrors) {
            this.operand = operand;
            this.reportErrors = reportErrors;
        }

        static ResolvedOffsetOptions of(Map<String, Object> options) {
            boolean reportErrors = OptUtils.reportErrors(options);
            int operand = 0;
            Integer addOption = OptUtils.getInteger(options, reportErrors, "add");
            Integer subtractOption = OptUtils.getInteger(options, reportErrors, "subtract");
            if (addOption == null) {
                if (subtractOption == null) {
                    throw new IllegalArgumentException("bad-option: :offset function needs an `add` or `subtract` option.");
                }
                operand = -OptUtils.asNumber(reportErrors, "subtract", subtractOption).intValue();
            } else if (subtractOption == null) {
                operand = OptUtils.asNumber(reportErrors, "add", addOption).intValue();
            } else {
                throw new IllegalArgumentException("bad-option: :offset function can't have both `add` and `subtract` options.");
            }
            return new ResolvedOffsetOptions(operand, reportErrors);
        }
    }

    static class NumberFunctionImpl
    implements Function {
        private static final String NO_MATCH = "\ufffdNO_MATCH\ufffe";
        private final Locale locale;
        private final Map<String, Object> fixedOptions;
        private final LocalizedNumberFormatter icuFormatter;
        private final String kind;
        private final PluralRules rules;

        NumberFunctionImpl(Locale locale, PluralRules rules, Map<String, Object> fixedOptions, String kind) {
            this.locale = OptUtils.getBestLocale(fixedOptions, locale);
            this.fixedOptions = new HashMap<String, Object>(fixedOptions);
            String skeleton = OptUtils.getString(fixedOptions, "icu:skeleton");
            boolean fancy = skeleton != null;
            this.icuFormatter = NumberFunctionFactory.functionForOptions(this.locale, fixedOptions, kind);
            this.kind = kind;
            this.rules = rules;
        }

        LocalizedNumberFormatter getIcuFormatter() {
            return this.icuFormatter;
        }

        @Override
        public String formatToString(Object toFormat, Map<String, Object> variableOptions) {
            return this.format(toFormat, variableOptions).toString();
        }

        @Override
        public FormattedPlaceholder format(Object toFormat, Map<String, Object> variableOptions) {
            FormattedValue result;
            LocalizedNumberFormatter realFormatter;
            HashMap<String, Object> mergedOptions = new HashMap<String, Object>(this.fixedOptions);
            if (variableOptions.isEmpty()) {
                realFormatter = this.icuFormatter;
            } else {
                mergedOptions.putAll(variableOptions);
                realFormatter = NumberFunctionFactory.functionForOptions(this.locale, mergedOptions, this.kind);
            }
            if (toFormat == null) {
                throw new NullPointerException("Argument to format can't be null");
            }
            if (toFormat instanceof CurrencyAmount) {
                result = realFormatter.format((CurrencyAmount)toFormat);
            } else {
                Number toFormatAdjusted;
                boolean isInt = this.kind.equals("integer");
                if (isInt) {
                    if (toFormat instanceof CharSequence) {
                        toFormat = OptUtils.asNumber(toFormat);
                    }
                    if (toFormat instanceof Number) {
                        toFormat = ((Number)toFormat).longValue();
                    }
                }
                if ((toFormatAdjusted = this.resolveValue(toFormat, variableOptions)) == null) {
                    String strValue = Objects.toString(toFormat);
                    result = new PlainStringFormattedValue("{|" + strValue + "|}");
                } else {
                    result = realFormatter.format(toFormatAdjusted);
                }
            }
            Directionality dir = OptUtils.getBestDirectionality(variableOptions, this.locale);
            return new FormattedPlaceholder(toFormat, result, dir, false);
        }

        @Override
        public List<String> matches(Object value, List<String> keys, Map<String, Object> variableOptions) {
            if (this.kind.equals("currency")) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            if (value == null) {
                return result;
            }
            for (String key2 : keys) {
                if (this.matches(value, key2, variableOptions)) {
                    result.add(key2);
                    continue;
                }
                result.add(NO_MATCH);
            }
            result.sort(NumberFunctionImpl::pluralComparator);
            return result;
        }

        private static int pluralComparator(String o1, String o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            if (NO_MATCH.equals(o1)) {
                return 1;
            }
            if (NO_MATCH.equals(o2)) {
                return -1;
            }
            if (MFDataModel.CatchallKey.isCatchAll(o1)) {
                return 1;
            }
            if (MFDataModel.CatchallKey.isCatchAll(o2)) {
                return -1;
            }
            if (OptUtils.asNumber(o1) != null) {
                return -1;
            }
            if (OptUtils.asNumber(o2) != null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        private boolean matches(Object value, String key2, Map<String, Object> variableOptions) {
            String match;
            Number keyNrVal;
            if (MFDataModel.CatchallKey.isCatchAll(key2)) {
                return true;
            }
            boolean reportErrors = OptUtils.reportErrors(this.fixedOptions);
            Number valToCheck = Double.MIN_VALUE;
            if (value instanceof FormattedPlaceholder) {
                FormattedPlaceholder fph = (FormattedPlaceholder)value;
                value = fph.getInput();
            }
            if (value instanceof Number || value instanceof CharSequence) {
                valToCheck = this.resolveValue(value, variableOptions);
                if (valToCheck == null) {
                    return false;
                }
            } else {
                return false;
            }
            if (Objects.equals(this.kind, "integer")) {
                valToCheck = valToCheck.longValue();
            }
            if ((keyNrVal = OptUtils.asNumber(key2)) != null && valToCheck.doubleValue() == keyNrVal.doubleValue()) {
                return true;
            }
            FormattedNumber formatted = this.icuFormatter.format(valToCheck.doubleValue());
            if (this.rules != null) {
                match = this.rules.select(formatted);
            } else {
                String string2 = match = key2.equals(formatted.toString()) ? key2 : "other";
            }
            if (match.equals("other")) {
                match = "<<::CatchallKey::>>";
            }
            return match.equals(key2);
        }

        private Number resolveValue(Object toFormat, Map<String, Object> variableOptions) {
            String currencyCode;
            boolean reportErrors;
            Integer offset;
            HashMap<String, Object> mergedOptions = new HashMap<String, Object>(this.fixedOptions);
            if (!variableOptions.isEmpty()) {
                mergedOptions.putAll(variableOptions);
            }
            if ((offset = OptUtils.getInteger(mergedOptions, reportErrors = OptUtils.reportErrors(mergedOptions), "icu:offset")) == null && this.fixedOptions != null) {
                offset = OptUtils.getInteger(this.fixedOptions, reportErrors, "icu:offset");
            }
            if (offset == null) {
                offset = 0;
            }
            int offsetOperand = 0;
            if (Objects.equals(this.kind, "offset")) {
                ResolvedOffsetOptions resolvedOffsetOptions = ResolvedOffsetOptions.of(mergedOptions);
                offsetOperand = resolvedOffsetOptions.operand;
            }
            if (this.kind.equals("currency") && (currencyCode = NumberFunctionFactory.getCurrency(mergedOptions)) == null && !(toFormat instanceof CurrencyAmount)) {
                throw new IllegalArgumentException("bad-option: the `currency` must be an ISO 4217 code.");
            }
            boolean isPercent = this.kind.equals("percent");
            boolean isInt = this.kind.equals("integer");
            if (toFormat == null) {
                throw new NullPointerException("Argument to format can't be null");
            }
            if (toFormat instanceof Double) {
                if (isInt) {
                    toFormat = Math.floor((Double)toFormat);
                }
                double toFormatAdjusted = (Double)toFormat - (double)offset.intValue() + (double)offsetOperand;
                if (isPercent) {
                    toFormatAdjusted *= 100.0;
                }
                return toFormatAdjusted;
            }
            if (toFormat instanceof Long) {
                long toFormatAdjusted = (Long)toFormat - (long)offset.intValue() + (long)offsetOperand;
                if (isPercent) {
                    toFormatAdjusted *= 100L;
                }
                return toFormatAdjusted;
            }
            if (toFormat instanceof Integer) {
                int toFormatAdjusted = (Integer)toFormat - offset + offsetOperand;
                if (isPercent) {
                    toFormatAdjusted *= 100;
                }
                return toFormatAdjusted;
            }
            if (toFormat instanceof BigDecimal) {
                BigDecimal toFormatAdjusted = (BigDecimal)toFormat;
                if (isPercent) {
                    toFormatAdjusted = toFormatAdjusted.multiply(BigDecimal.valueOf(100L));
                }
                if (isInt) {
                    toFormat = toFormatAdjusted.longValue();
                }
                toFormatAdjusted = toFormatAdjusted.subtract(BigDecimal.valueOf(offset.intValue()));
                if (offsetOperand != 0) {
                    toFormatAdjusted = toFormatAdjusted.add(BigDecimal.valueOf(offsetOperand));
                }
                return toFormatAdjusted;
            }
            if (toFormat instanceof Number) {
                if (isInt) {
                    toFormat = Math.floor(((Number)toFormat).doubleValue());
                }
                double toFormatAdjusted = ((Number)toFormat).doubleValue() - (double)offset.intValue() + (double)offsetOperand;
                if (isPercent) {
                    toFormatAdjusted *= 100.0;
                }
                return toFormatAdjusted;
            }
            if (toFormat instanceof CurrencyAmount) {
                return ((CurrencyAmount)toFormat).getNumber();
            }
            String strValue = Objects.toString(toFormat);
            Number nrValue = OptUtils.asNumber(reportErrors, "argument", strValue);
            if (nrValue != null) {
                double toFormatAdjusted;
                double d = toFormatAdjusted = isInt ? (double)nrValue.intValue() : nrValue.doubleValue() - (double)offset.intValue() + (double)offsetOperand;
                if (isPercent) {
                    toFormatAdjusted *= 100.0;
                }
                return toFormatAdjusted;
            }
            return null;
        }
    }
}

