/*
 * Decompiled with CFR 0.152.
 */
package esc.ai;

import de.kherud.llama.InferenceParameters;
import de.kherud.llama.LlamaModel;
import de.kherud.llama.ModelParameters;
import esc.configuration.AiConfig;
import esc.configuration.AiConfig$;
import java.io.Serializable;
import java.nio.file.Paths;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class LMRunner$
implements Serializable {
    private static boolean isLoaded;
    private static Option<LlamaModel> lmModel;
    private static String modelPath;
    private static AiConfig _aiConfig;
    public static final LMRunner$ MODULE$;

    private LMRunner$() {
    }

    static {
        MODULE$ = new LMRunner$();
        isLoaded = false;
        lmModel = None$.MODULE$;
        modelPath = "";
        _aiConfig = new AiConfig(AiConfig$.MODULE$.$lessinit$greater$default$1(), AiConfig$.MODULE$.$lessinit$greater$default$2(), AiConfig$.MODULE$.$lessinit$greater$default$3(), AiConfig$.MODULE$.$lessinit$greater$default$4(), AiConfig$.MODULE$.$lessinit$greater$default$5(), AiConfig$.MODULE$.$lessinit$greater$default$6(), AiConfig$.MODULE$.$lessinit$greater$default$7(), AiConfig$.MODULE$.$lessinit$greater$default$8(), AiConfig$.MODULE$.$lessinit$greater$default$9(), AiConfig$.MODULE$.$lessinit$greater$default$10(), AiConfig$.MODULE$.$lessinit$greater$default$11(), AiConfig$.MODULE$.$lessinit$greater$default$12(), AiConfig$.MODULE$.$lessinit$greater$default$13(), AiConfig$.MODULE$.$lessinit$greater$default$14());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LMRunner$.class);
    }

    public AiConfig aiConfig() {
        return _aiConfig;
    }

    public void changeAiConfig(AiConfig newAiConfig) {
        _aiConfig = newAiConfig;
        if (isLoaded && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(modelPath))) {
            this.loadModel(modelPath);
            return;
        }
    }

    public void loadModel(String path) {
        LMRunner$ lMRunner$ = this;
        synchronized (lMRunner$) {
            modelPath = path;
            ModelParameters p = new ModelParameters();
            p.setModel(Paths.get(path, new String[0]).toString());
            p.setCtxSize(this.aiConfig().modelContextSize());
            p.setBatchSize(this.aiConfig().modelBatchSize());
            p.setGpuLayers(this.aiConfig().modelGpuLayers());
            p.setThreads(this.aiConfig().modelThreads());
            p.setThreadsBatch(this.aiConfig().modelThreads());
            LlamaModel m = new LlamaModel(p);
            lmModel = Some$.MODULE$.apply(m);
            isLoaded = true;
        }
    }

    public String prompt(String prompt, Option<Object> maxTokens) {
        String string2;
        LMRunner$ lMRunner$ = this;
        synchronized (lMRunner$) {
            String result;
            Predef$.MODULE$.require(isLoaded && lmModel.isDefined(), LMRunner$::prompt$$anonfun$1);
            InferenceParameters inferParams = this.createInferenceParams(prompt, maxTokens);
            string2 = result = lmModel.get().complete(inferParams);
        }
        return string2;
    }

    public Option<Object> prompt$default$2() {
        return None$.MODULE$;
    }

    private InferenceParameters createInferenceParams(String prompt, Option<Object> maxTokens) {
        InferenceParameters p = new InferenceParameters(prompt);
        p.setTemperature(this.aiConfig().inferenceTemperature());
        p.setTopK(this.aiConfig().inferenceTopK());
        p.setTopP(this.aiConfig().inferenceTopP());
        p.setMinP(this.aiConfig().inferenceMinP());
        p.setRepeatPenalty(this.aiConfig().inferenceRepeatPenalty());
        p.setNPredict(BoxesRunTime.unboxToInt(maxTokens.getOrElse(LMRunner$::createInferenceParams$$anonfun$1)));
        p.setPresencePenalty(this.aiConfig().inferencePresencePenalty());
        p.setFrequencyPenalty(this.aiConfig().inferenceFrequencyPenalty());
        p.setStopStrings(this.aiConfig().inferenceStopList());
        return p;
    }

    private Option<Object> createInferenceParams$default$2() {
        return None$.MODULE$;
    }

    private void close() {
        LMRunner$ lMRunner$ = this;
        synchronized (lMRunner$) {
            lmModel.foreach(_$1 -> _$1.close());
            lmModel = None$.MODULE$;
            isLoaded = false;
        }
    }

    private static final Object prompt$$anonfun$1() {
        return "Model not loaded. First load the model via loadModel(path)";
    }

    private static final int createInferenceParams$$anonfun$1() {
        return MODULE$.aiConfig().inferenceMaxTokens();
    }
}

