/*
 * Decompiled with CFR 0.152.
 */
package esc.normalization;

import com.ibm.icu.text.Transliterator;
import esc.ai.AiAgent$;
import java.io.Serializable;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class Transliterator$
implements Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Transliterator$.class.getDeclaredField("scriptToTransliterator$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Transliterator$.class.getDeclaredField("defaultTransliterator$lzy1"));
    private static String RULE_SET;
    private volatile Object defaultTransliterator$lzy1;
    private volatile Object scriptToTransliterator$lzy1;
    public static final Transliterator$ MODULE$;

    private Transliterator$() {
    }

    static {
        MODULE$ = new Transliterator$();
        RULE_SET = "Any-Latin; NFD; Latin-ASCII";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Transliterator$.class);
    }

    private Transliterator defaultTransliterator() {
        Object object = this.defaultTransliterator$lzy1;
        if (object instanceof Transliterator) {
            return (Transliterator)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Transliterator)this.defaultTransliterator$lzyINIT1();
    }

    private Object defaultTransliterator$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.defaultTransliterator$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$_m_0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Transliterator transliterator = null;
                    try {
                        transliterator = Transliterator.getInstance(RULE_SET);
                        object2 = transliterator == null ? LazyVals$NullValue$.MODULE$ : transliterator;
                        RULE_SET = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$_m_0, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultTransliterator$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$_m_0, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return transliterator;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$_m_0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Map<String, Transliterator> scriptToTransliterator() {
        Object object = this.scriptToTransliterator$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.scriptToTransliterator$lzyINIT1();
    }

    private Object scriptToTransliterator$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.scriptToTransliterator$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$_m_1, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        Tuple2[] tuple2Array = new Tuple2[26];
                        String string2 = Predef$.MODULE$.ArrowAssoc("arabic");
                        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, Transliterator.getInstance("Arabic-Latin; NFD; Latin-ASCII"));
                        String string3 = Predef$.MODULE$.ArrowAssoc("cyrillic");
                        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, Transliterator.getInstance("Cyrillic-Latin; NFD; Latin-ASCII"));
                        String string4 = Predef$.MODULE$.ArrowAssoc("japanese");
                        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, Transliterator.getInstance("Kana-Latin; NFD; Latin-ASCII"));
                        String string5 = Predef$.MODULE$.ArrowAssoc("chinese");
                        tuple2Array[3] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string5, Transliterator.getInstance("Han-Latin; NFD; Latin-ASCII"));
                        String string6 = Predef$.MODULE$.ArrowAssoc("greek");
                        tuple2Array[4] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string6, Transliterator.getInstance("Greek-Latin; NFD; Latin-ASCII"));
                        String string7 = Predef$.MODULE$.ArrowAssoc("korean");
                        tuple2Array[5] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string7, Transliterator.getInstance("Hangul-Latin; NFD; Latin-ASCII"));
                        String string8 = Predef$.MODULE$.ArrowAssoc("thai");
                        tuple2Array[6] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string8, Transliterator.getInstance("Thai-Latin; NFD; Latin-ASCII"));
                        String string9 = Predef$.MODULE$.ArrowAssoc("armenian");
                        tuple2Array[7] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string9, Transliterator.getInstance("Armenian-Latin; NFD; Latin-ASCII"));
                        String string10 = Predef$.MODULE$.ArrowAssoc("hebrew");
                        tuple2Array[8] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string10, Transliterator.getInstance("Hebrew-Latin; NFD; Latin-ASCII"));
                        String string11 = Predef$.MODULE$.ArrowAssoc("devanagari");
                        tuple2Array[9] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string11, Transliterator.getInstance("Devanagari-Latin; NFD; Latin-ASCII"));
                        String string12 = Predef$.MODULE$.ArrowAssoc("georgian");
                        tuple2Array[10] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string12, Transliterator.getInstance("Georgian-Latin; NFD; Latin-ASCII"));
                        String string13 = Predef$.MODULE$.ArrowAssoc("latin");
                        tuple2Array[11] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string13, Transliterator.getInstance("Latin-ASCII"));
                        String string14 = Predef$.MODULE$.ArrowAssoc("ethiopic");
                        tuple2Array[12] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string14, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        String string15 = Predef$.MODULE$.ArrowAssoc("lao");
                        tuple2Array[13] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string15, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        String string16 = Predef$.MODULE$.ArrowAssoc("tibetan");
                        tuple2Array[14] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string16, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        String string17 = Predef$.MODULE$.ArrowAssoc("myanmar");
                        tuple2Array[15] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string17, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        String string18 = Predef$.MODULE$.ArrowAssoc("khmer");
                        tuple2Array[16] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string18, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        String string19 = Predef$.MODULE$.ArrowAssoc("bengali");
                        tuple2Array[17] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string19, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        String string20 = Predef$.MODULE$.ArrowAssoc("gujarati");
                        tuple2Array[18] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string20, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        String string21 = Predef$.MODULE$.ArrowAssoc("gurmukhi");
                        tuple2Array[19] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string21, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        String string22 = Predef$.MODULE$.ArrowAssoc("kannada");
                        tuple2Array[20] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string22, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        String string23 = Predef$.MODULE$.ArrowAssoc("malayalam");
                        tuple2Array[21] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string23, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        String string24 = Predef$.MODULE$.ArrowAssoc("tamil");
                        tuple2Array[22] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string24, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        String string25 = Predef$.MODULE$.ArrowAssoc("telugu");
                        tuple2Array[23] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string25, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        String string26 = Predef$.MODULE$.ArrowAssoc("sinhala");
                        tuple2Array[24] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string26, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        String string27 = Predef$.MODULE$.ArrowAssoc("default");
                        tuple2Array[25] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string27, Transliterator.getInstance("Any-Latin; NFD; Latin-ASCII"));
                        map = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
                        object2 = map == null ? LazyVals$NullValue$.MODULE$ : map;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$_m_1, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.scriptToTransliterator$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$_m_1, waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$_m_1, LazyVals$Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.scriptToTransliterator$lzy1;
                        LazyVals$.MODULE$.objCAS(this, OFFSET$_m_1, waiting, object2);
                        waiting.countDown();
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$_m_1, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private String detectScript(String s) {
        Regex arabic = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsArabic}"));
        Regex cyrillic = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsCyrillic}"));
        Regex hiragana = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsHiragana}"));
        Regex katakana = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsKatakana}"));
        Regex han = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsHan}"));
        Regex greek = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsGreek}"));
        Regex hangul = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsHangul}"));
        Regex thai = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsThai}"));
        Regex armenian = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsArmenian}"));
        Regex hebrew = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsHebrew}"));
        Regex devanagari = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsDevanagari}"));
        Regex latin = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsLatin}"));
        Regex georgian = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsGeorgian}"));
        Regex ethiopic = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsEthiopic}"));
        Regex lao = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsLao}"));
        Regex tibetan = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsTibetan}"));
        Regex myanmar = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsMyanmar}"));
        Regex khmer = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsKhmer}"));
        Regex bengali = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsBengali}"));
        Regex gujarati = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsGujarati}"));
        Regex gurmukhi = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsGurmukhi}"));
        Regex kannada = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsKannada}"));
        Regex malayalam = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsMalayalam}"));
        Regex tamil = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsTamil}"));
        Regex telugu = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsTelugu}"));
        Regex sinhala = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\p{IsSinhala}"));
        if (arabic.findFirstIn(s).isDefined()) {
            return "arabic";
        }
        if (cyrillic.findFirstIn(s).isDefined()) {
            return "cyrillic";
        }
        if (hiragana.findFirstIn(s).isDefined() || katakana.findFirstIn(s).isDefined()) {
            return "japanese";
        }
        if (han.findFirstIn(s).isDefined()) {
            return "chinese";
        }
        if (greek.findFirstIn(s).isDefined()) {
            return "greek";
        }
        if (hangul.findFirstIn(s).isDefined()) {
            return "korean";
        }
        if (thai.findFirstIn(s).isDefined()) {
            return "thai";
        }
        if (armenian.findFirstIn(s).isDefined()) {
            return "armenian";
        }
        if (hebrew.findFirstIn(s).isDefined()) {
            return "hebrew";
        }
        if (devanagari.findFirstIn(s).isDefined()) {
            return "devanagari";
        }
        if (latin.findFirstIn(s).isDefined()) {
            return "latin";
        }
        if (georgian.findFirstIn(s).isDefined()) {
            return "georgian";
        }
        if (ethiopic.findFirstIn(s).isDefined()) {
            return "ethiopic";
        }
        if (lao.findFirstIn(s).isDefined()) {
            return "lao";
        }
        if (tibetan.findFirstIn(s).isDefined()) {
            return "tibetan";
        }
        if (myanmar.findFirstIn(s).isDefined()) {
            return "myanmar";
        }
        if (khmer.findFirstIn(s).isDefined()) {
            return "khmer";
        }
        if (bengali.findFirstIn(s).isDefined()) {
            return "bengali";
        }
        if (gujarati.findFirstIn(s).isDefined()) {
            return "gujarati";
        }
        if (gurmukhi.findFirstIn(s).isDefined()) {
            return "gurmukhi";
        }
        if (kannada.findFirstIn(s).isDefined()) {
            return "kannada";
        }
        if (malayalam.findFirstIn(s).isDefined()) {
            return "malayalam";
        }
        if (tamil.findFirstIn(s).isDefined()) {
            return "tamil";
        }
        if (telugu.findFirstIn(s).isDefined()) {
            return "telugu";
        }
        if (sinhala.findFirstIn(s).isDefined()) {
            return "sinhala";
        }
        return "default";
    }

    public String transToLatin(String text) {
        Transliterator translator = (Transliterator)this.scriptToTransliterator().getOrElse(this.detectScript(text), Transliterator$::$anonfun$1);
        return translator.transliterate(text);
    }

    public String transToLatinWithAi(String text) {
        String detectedScript = this.detectScript(text);
        String string2 = detectedScript;
        if ("default".equals(string2)) {
            Transliterator translator = (Transliterator)this.scriptToTransliterator().getOrElse(detectedScript, Transliterator$::$anonfun$2);
            return translator.transliterate(text);
        }
        if ("latin".equals(string2)) {
            return text;
        }
        Predef$.MODULE$.println(new StringBuilder(8).append("Aitrans ").append(text).toString());
        return AiAgent$.MODULE$.transToLatin(text);
    }

    public String transToLatinBestGuess(String text) {
        String detectedScript = this.detectScript(text);
        String string2 = detectedScript;
        switch (string2 == null ? 0 : string2.hashCode()) {
            case -1712101712: {
                if (!"devanagari".equals(string2)) break;
                Transliterator translator = (Transliterator)this.scriptToTransliterator().getOrElse(detectedScript, Transliterator$::$anonfun$8);
                return translator.transliterate(text);
            }
            case -1432650703: {
                if (!"armenian".equals(string2)) break;
                Transliterator translator = (Transliterator)this.scriptToTransliterator().getOrElse(detectedScript, Transliterator$::$anonfun$6);
                return translator.transliterate(text);
            }
            case -1221227649: {
                if (!"hebrew".equals(string2)) break;
                Transliterator translator = (Transliterator)this.scriptToTransliterator().getOrElse(detectedScript, Transliterator$::$anonfun$5);
                return translator.transliterate(text);
            }
            case -1125640956: {
                if (!"korean".equals(string2)) break;
                Transliterator translator = (Transliterator)this.scriptToTransliterator().getOrElse(detectedScript, Transliterator$::$anonfun$9);
                return translator.transliterate(text);
            }
            case -177655481: {
                if (!"cyrillic".equals(string2)) break;
                Transliterator translator = (Transliterator)this.scriptToTransliterator().getOrElse(detectedScript, Transliterator$::$anonfun$3);
                return translator.transliterate(text);
            }
            case 98619136: {
                if (!"greek".equals(string2)) break;
                Transliterator translator = (Transliterator)this.scriptToTransliterator().getOrElse(detectedScript, Transliterator$::$anonfun$4);
                return translator.transliterate(text);
            }
            case 102744836: {
                if (!"latin".equals(string2)) break;
                return text;
            }
            case 110126275: {
                if (!"tamil".equals(string2)) break;
                Transliterator translator = (Transliterator)this.scriptToTransliterator().getOrElse(detectedScript, Transliterator$::$anonfun$10);
                return translator.transliterate(text);
            }
            case 1850686288: {
                if (!"georgian".equals(string2)) break;
                Transliterator translator = (Transliterator)this.scriptToTransliterator().getOrElse(detectedScript, Transliterator$::$anonfun$7);
                return translator.transliterate(text);
            }
        }
        return AiAgent$.MODULE$.transToLatin(text);
    }

    private static final Transliterator $anonfun$1() {
        return MODULE$.defaultTransliterator();
    }

    private static final Transliterator $anonfun$2() {
        return MODULE$.defaultTransliterator();
    }

    private static final Transliterator $anonfun$3() {
        return MODULE$.defaultTransliterator();
    }

    private static final Transliterator $anonfun$4() {
        return MODULE$.defaultTransliterator();
    }

    private static final Transliterator $anonfun$5() {
        return MODULE$.defaultTransliterator();
    }

    private static final Transliterator $anonfun$6() {
        return MODULE$.defaultTransliterator();
    }

    private static final Transliterator $anonfun$7() {
        return MODULE$.defaultTransliterator();
    }

    private static final Transliterator $anonfun$8() {
        return MODULE$.defaultTransliterator();
    }

    private static final Transliterator $anonfun$9() {
        return MODULE$.defaultTransliterator();
    }

    private static final Transliterator $anonfun$10() {
        return MODULE$.defaultTransliterator();
    }
}

