/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class DictEntry {
    private final String stem;

    DictEntry(String stem) {
        this.stem = stem;
    }

    public String toString() {
        String morph;
        Object result = this.stem;
        String flags = this.getFlags();
        if (!flags.isEmpty()) {
            result = (String)result + "/" + flags;
        }
        if (!(morph = this.getMorphologicalData()).isEmpty()) {
            result = (String)result + " " + morph;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DictEntry)) {
            return false;
        }
        DictEntry that = (DictEntry)o;
        return this.stem.equals(that.stem) && this.getMorphologicalData().equals(that.getMorphologicalData()) && this.getFlags().equals(that.getFlags());
    }

    public int hashCode() {
        return Objects.hash(this.stem, this.getFlags(), this.getMorphologicalData());
    }

    public String getStem() {
        return this.stem;
    }

    public abstract String getFlags();

    public abstract String getMorphologicalData();

    public List<String> getMorphologicalValues(String key2) {
        assert (key2.length() == 3 && key2.charAt(2) == ':') : "A morphological data key should consist of two letters followed by a semicolon, found: " + key2;
        String data = this.getMorphologicalData();
        if (data.isEmpty() || !data.contains(key2)) {
            return Collections.emptyList();
        }
        return Arrays.stream(data.split(" ")).filter(s -> s.startsWith(key2)).map(s -> s.substring(3)).toList();
    }

    static DictEntry create(String stem, final String flags) {
        return new DictEntry(stem){

            @Override
            public String getFlags() {
                return flags;
            }

            @Override
            public String getMorphologicalData() {
                return "";
            }
        };
    }
}

