/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;

public class StringDocValuesReaderState {
    final IndexReader reader;
    final String field;
    final OrdinalMap ordinalMap;

    public StringDocValuesReaderState(IndexReader reader, String field2) throws IOException {
        this.reader = reader;
        this.field = field2;
        this.ordinalMap = StringDocValuesReaderState.buildOrdinalMap(reader, field2);
    }

    private static OrdinalMap buildOrdinalMap(IndexReader reader, String field2) throws IOException {
        List<LeafReaderContext> leaves = reader.leaves();
        int leafCount = leaves.size();
        if (leafCount <= 1) {
            return null;
        }
        SortedSetDocValues[] docValues = new SortedSetDocValues[leafCount];
        for (int i = 0; i < leafCount; ++i) {
            LeafReaderContext context = reader.leaves().get(i);
            docValues[i] = DocValues.getSortedSet(context.reader(), field2);
        }
        IndexReader.CacheHelper cacheHelper = reader.getReaderCacheHelper();
        IndexReader.CacheKey owner = cacheHelper == null ? null : cacheHelper.getKey();
        return OrdinalMap.build(owner, docValues, 0.25f);
    }

    public String toString() {
        return "StringDocValuesReaderState(field=" + this.field + " reader=" + String.valueOf(this.reader) + ")";
    }
}

