/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.geo.Polygon;

class SimpleGeoJSONPolygonParser {
    final String input;
    private int upto;
    private String polyType;
    private List<Object> coordinates;

    public SimpleGeoJSONPolygonParser(String input) {
        this.input = input;
    }

    public Polygon[] parse() throws ParseException {
        this.parseObject("");
        this.readEnd();
        if (this.coordinates == null) {
            throw this.newParseException("did not see any polygon coordinates");
        }
        if (this.polyType == null) {
            throw this.newParseException("did not see type: Polygon or MultiPolygon");
        }
        if (this.polyType.equals("Polygon")) {
            return new Polygon[]{this.parsePolygon(this.coordinates)};
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < this.coordinates.size(); ++i) {
            Object o = this.coordinates.get(i);
            if (!(o instanceof List)) {
                throw this.newParseException("elements of coordinates array should be an array, but got: " + String.valueOf(o.getClass()));
            }
            polygons.add(this.parsePolygon((List)o));
        }
        return polygons.toArray(new Polygon[polygons.size()]);
    }

    private void parseObject(String path) throws ParseException {
        char ch;
        this.scan('{');
        boolean first = true;
        while ((ch = this.peek()) != '}') {
            Object o;
            if (!first) {
                if (ch == ',') {
                    ++this.upto;
                    ch = this.peek();
                    if (ch == '}') {
                        break;
                    }
                } else {
                    throw this.newParseException("expected , but got " + ch);
                }
            }
            first = false;
            int uptoStart = this.upto;
            String key2 = this.parseString();
            if (path.equals("crs.properties") && key2.equals("href")) {
                this.upto = uptoStart;
                throw this.newParseException("cannot handle linked crs");
            }
            this.scan(':');
            ch = this.peek();
            uptoStart = this.upto;
            if (ch == '[') {
                newPath = path.length() == 0 ? key2 : path + "." + key2;
                o = this.parseArray((String)newPath);
            } else if (ch == '{') {
                newPath = path.length() == 0 ? key2 : path + "." + key2;
                this.parseObject((String)newPath);
                o = null;
            } else if (ch == '\"') {
                o = this.parseString();
            } else if (ch == 't') {
                this.scan("true");
                o = Boolean.TRUE;
            } else if (ch == 'f') {
                this.scan("false");
                o = Boolean.FALSE;
            } else if (ch == 'n') {
                this.scan("null");
                o = null;
            } else if (ch == '-' || ch == '.' || ch >= '0' && ch <= '9') {
                o = this.parseNumber();
            } else {
                if (ch == '}') break;
                throw this.newParseException("expected array, object, string or literal value, but got: " + ch);
            }
            if (path.equals("crs.properties") && key2.equals("name")) {
                if (!(o instanceof String)) {
                    this.upto = uptoStart;
                    throw this.newParseException("crs.properties.name should be a string, but saw: " + String.valueOf(o));
                }
                String crs = (String)o;
                if (!crs.startsWith("urn:ogc:def:crs:OGC") || !crs.endsWith(":CRS84")) {
                    this.upto = uptoStart;
                    throw this.newParseException("crs must be CRS84 from OGC, but saw: " + String.valueOf(o));
                }
            }
            if (key2.equals("type") && !path.startsWith("crs")) {
                if (!(o instanceof String)) {
                    this.upto = uptoStart;
                    throw this.newParseException("type should be a string, but got: " + String.valueOf(o));
                }
                String type = (String)o;
                if (type.equals("Polygon") && this.isValidGeometryPath(path)) {
                    this.polyType = "Polygon";
                    continue;
                }
                if (type.equals("MultiPolygon") && this.isValidGeometryPath(path)) {
                    this.polyType = "MultiPolygon";
                    continue;
                }
                if (!(!type.equals("FeatureCollection") && !type.equals("Feature") || !path.equals("features.[]") && !path.isEmpty())) continue;
                this.upto = uptoStart;
                throw this.newParseException("can only handle type FeatureCollection (if it has a single polygon geometry), Feature, Polygon or MultiPolygon, but got " + type);
            }
            if (!key2.equals("coordinates") || !this.isValidGeometryPath(path)) continue;
            if (!(o instanceof List)) {
                this.upto = uptoStart;
                throw this.newParseException("coordinates should be an array, but got: " + String.valueOf(o.getClass()));
            }
            if (this.coordinates != null) {
                this.upto = uptoStart;
                throw this.newParseException("only one Polygon or MultiPolygon is supported");
            }
            this.coordinates = (List)o;
        }
        this.scan('}');
    }

    private boolean isValidGeometryPath(String path) {
        return path.isEmpty() || path.equals("geometry") || path.equals("features.[].geometry");
    }

    private Polygon parsePolygon(List<Object> coordinates) throws ParseException {
        ArrayList<Polygon> holes = new ArrayList<Polygon>();
        Object o = coordinates.get(0);
        if (!(o instanceof List)) {
            throw this.newParseException("first element of polygon array must be an array [[lat, lon], [lat, lon] ...] but got: " + String.valueOf(o));
        }
        double[][] polyPoints = this.parsePoints((List)o);
        for (int i = 1; i < coordinates.size(); ++i) {
            o = coordinates.get(i);
            if (!(o instanceof List)) {
                throw this.newParseException("elements of coordinates array must be an array [[lat, lon], [lat, lon] ...] but got: " + String.valueOf(o));
            }
            double[][] holePoints = this.parsePoints((List)o);
            holes.add(new Polygon(holePoints[0], holePoints[1], new Polygon[0]));
        }
        return new Polygon(polyPoints[0], polyPoints[1], holes.toArray(new Polygon[holes.size()]));
    }

    private double[][] parsePoints(List<Object> o) throws ParseException {
        double[] lats = new double[o.size()];
        double[] lons = new double[o.size()];
        for (int i = 0; i < o.size(); ++i) {
            Object point = o.get(i);
            if (!(point instanceof List)) {
                throw this.newParseException("elements of coordinates array must [lat, lon] array, but got: " + String.valueOf(point));
            }
            List pointList = (List)point;
            if (pointList.size() != 2) {
                throw this.newParseException("elements of coordinates array must [lat, lon] array, but got wrong element count: " + String.valueOf(pointList));
            }
            if (!(pointList.get(0) instanceof Double)) {
                throw this.newParseException("elements of coordinates array must [lat, lon] array, but first element is not a Double: " + String.valueOf(pointList.get(0)));
            }
            if (!(pointList.get(1) instanceof Double)) {
                throw this.newParseException("elements of coordinates array must [lat, lon] array, but second element is not a Double: " + String.valueOf(pointList.get(1)));
            }
            lons[i] = (Double)pointList.get(0);
            lats[i] = (Double)pointList.get(1);
        }
        return new double[][]{lats, lons};
    }

    private List<Object> parseArray(String path) throws ParseException {
        ArrayList<Object> result = new ArrayList<Object>();
        this.scan('[');
        while (this.upto < this.input.length()) {
            Object o;
            char ch = this.peek();
            if (ch == ']') {
                this.scan(']');
                return result;
            }
            if (result.size() > 0) {
                if (ch != ',') {
                    throw this.newParseException("expected ',' separating list items, but got '" + ch + "'");
                }
                ++this.upto;
                if (this.upto == this.input.length()) {
                    throw this.newParseException("hit EOF while parsing array");
                }
                ch = this.peek();
            }
            if (ch == '[') {
                o = this.parseArray(path + ".[]");
            } else if (ch == '{') {
                this.parseObject(path + ".[]");
                o = null;
            } else if (ch == '-' || ch == '.' || ch >= '0' && ch <= '9') {
                o = this.parseNumber();
            } else if (ch == '\"') {
                o = this.parseString();
            } else {
                throw this.newParseException("expected another array or number while parsing array, not '" + ch + "'");
            }
            result.add(o);
        }
        throw this.newParseException("hit EOF while reading array");
    }

    private Number parseNumber() throws ParseException {
        char ch;
        StringBuilder b = new StringBuilder();
        int uptoStart = this.upto;
        while (this.upto < this.input.length() && ((ch = this.input.charAt(this.upto)) == '-' || ch == '.' || ch >= '0' && ch <= '9' || ch == 'e' || ch == 'E')) {
            ++this.upto;
            b.append(ch);
        }
        try {
            return Double.parseDouble(b.toString());
        }
        catch (NumberFormatException nfe) {
            this.upto = uptoStart;
            throw this.newParseException("could not parse number as double");
        }
    }

    private String parseString() throws ParseException {
        this.scan('\"');
        StringBuilder b = new StringBuilder();
        while (this.upto < this.input.length()) {
            char ch = this.input.charAt(this.upto);
            if (ch == '\"') {
                ++this.upto;
                return b.toString();
            }
            if (ch == '\\') {
                ++this.upto;
                if (this.upto == this.input.length()) {
                    throw this.newParseException("hit EOF inside string literal");
                }
                ch = this.input.charAt(this.upto);
                if (ch == 'u') {
                    ++this.upto;
                    if (this.upto + 4 > this.input.length()) {
                        throw this.newParseException("hit EOF inside string literal");
                    }
                    b.append(Integer.parseInt(this.input.substring(this.upto, this.upto + 4), 16));
                    continue;
                }
                if (ch == '\\') {
                    b.append('\\');
                    ++this.upto;
                    continue;
                }
                throw this.newParseException("unsupported string escape character \\" + ch);
            }
            b.append(ch);
            ++this.upto;
        }
        throw this.newParseException("hit EOF inside string literal");
    }

    private char peek() throws ParseException {
        while (this.upto < this.input.length()) {
            char ch = this.input.charAt(this.upto);
            if (SimpleGeoJSONPolygonParser.isJSONWhitespace(ch)) {
                ++this.upto;
                continue;
            }
            return ch;
        }
        throw this.newParseException("unexpected EOF");
    }

    private void scan(char expected) throws ParseException {
        while (this.upto < this.input.length()) {
            char ch = this.input.charAt(this.upto);
            if (SimpleGeoJSONPolygonParser.isJSONWhitespace(ch)) {
                ++this.upto;
                continue;
            }
            if (ch != expected) {
                throw this.newParseException("expected '" + expected + "' but got '" + ch + "'");
            }
            ++this.upto;
            return;
        }
        throw this.newParseException("expected '" + expected + "' but got EOF");
    }

    private void readEnd() throws ParseException {
        while (this.upto < this.input.length()) {
            char ch = this.input.charAt(this.upto);
            if (!SimpleGeoJSONPolygonParser.isJSONWhitespace(ch)) {
                throw this.newParseException("unexpected character '" + ch + "' after end of GeoJSON object");
            }
            ++this.upto;
        }
    }

    private void scan(String expected) throws ParseException {
        if (this.upto + expected.length() > this.input.length()) {
            throw this.newParseException("expected \"" + expected + "\" but hit EOF");
        }
        String subString = this.input.substring(this.upto, this.upto + expected.length());
        if (!subString.equals(expected)) {
            throw this.newParseException("expected \"" + expected + "\" but got \"" + subString + "\"");
        }
        this.upto += expected.length();
    }

    private static boolean isJSONWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    private ParseException newParseException(String details) throws ParseException {
        int end = Math.min(this.input.length(), this.upto + 1);
        Object fragment = this.upto < 50 ? this.input.substring(0, end) : "..." + this.input.substring(this.upto - 50, end);
        return new ParseException(details + " at character offset " + this.upto + "; fragment leading to this:\n" + (String)fragment, this.upto);
    }
}

