/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.VectorScorer;

public abstract class FloatVectorValues
extends KnnVectorValues {
    protected FloatVectorValues() {
    }

    public abstract float[] vectorValue(int var1) throws IOException;

    @Override
    public abstract FloatVectorValues copy() throws IOException;

    public static void checkField(LeafReader in, String field2) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field2);
        if (fi != null && fi.hasVectorValues() && fi.getVectorEncoding() != VectorEncoding.FLOAT32) {
            throw new IllegalStateException("Unexpected vector encoding (" + String.valueOf((Object)fi.getVectorEncoding()) + ") for field " + field2 + "(expected=" + String.valueOf((Object)VectorEncoding.FLOAT32) + ")");
        }
    }

    public VectorScorer scorer(float[] target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public VectorEncoding getEncoding() {
        return VectorEncoding.FLOAT32;
    }

    public static FloatVectorValues fromFloats(final List<float[]> vectors, final int dim) {
        return new FloatVectorValues(){

            @Override
            public int size() {
                return vectors.size();
            }

            @Override
            public int dimension() {
                return dim;
            }

            @Override
            public float[] vectorValue(int targetOrd) {
                return (float[])vectors.get(targetOrd);
            }

            @Override
            public FloatVectorValues copy() {
                return this;
            }

            @Override
            public KnnVectorValues.DocIndexIterator iterator() {
                return this.createDenseIterator();
            }
        };
    }
}

