/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.internal.hppc.LongArrayList;
import org.apache.lucene.store.Directory;

class SegmentDocValuesProducer
extends DocValuesProducer {
    final IntObjectHashMap<DocValuesProducer> dvProducersByField = new IntObjectHashMap();
    final Set<DocValuesProducer> dvProducers = Collections.newSetFromMap(new IdentityHashMap());
    final LongArrayList dvGens = new LongArrayList();

    SegmentDocValuesProducer(SegmentCommitInfo si, Directory dir, FieldInfos coreInfos, FieldInfos allInfos, SegmentDocValues segDocValues) throws IOException {
        try {
            DocValuesProducer baseProducer = null;
            for (FieldInfo fi : allInfos) {
                if (fi.getDocValuesType() == DocValuesType.NONE) continue;
                long docValuesGen = fi.getDocValuesGen();
                if (docValuesGen == -1L) {
                    if (baseProducer == null) {
                        baseProducer = segDocValues.getDocValuesProducer(docValuesGen, si, dir, coreInfos);
                        this.dvGens.add(docValuesGen);
                        this.dvProducers.add(baseProducer);
                    }
                    this.dvProducersByField.put(fi.number, baseProducer);
                    continue;
                }
                assert (!this.dvGens.contains(docValuesGen));
                DocValuesProducer dvp = segDocValues.getDocValuesProducer(docValuesGen, si, dir, new FieldInfos(new FieldInfo[]{fi}));
                this.dvGens.add(docValuesGen);
                this.dvProducers.add(dvp);
                this.dvProducersByField.put(fi.number, dvp);
            }
        }
        catch (Throwable t) {
            try {
                segDocValues.decRef(this.dvGens);
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            throw t;
        }
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo field2) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field2.number);
        assert (dvProducer != null);
        return dvProducer.getNumeric(field2);
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo field2) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field2.number);
        assert (dvProducer != null);
        return dvProducer.getBinary(field2);
    }

    @Override
    public SortedDocValues getSorted(FieldInfo field2) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field2.number);
        assert (dvProducer != null);
        return dvProducer.getSorted(field2);
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field2) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field2.number);
        assert (dvProducer != null);
        return dvProducer.getSortedNumeric(field2);
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field2) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field2.number);
        assert (dvProducer != null);
        return dvProducer.getSortedSet(field2);
    }

    @Override
    public DocValuesSkipper getSkipper(FieldInfo field2) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field2.number);
        assert (dvProducer != null);
        return dvProducer.getSkipper(field2);
    }

    @Override
    public void checkIntegrity() throws IOException {
        for (DocValuesProducer producer : this.dvProducers) {
            producer.checkIntegrity();
        }
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(producers=" + this.dvProducers.size() + ")";
    }
}

