/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn;

import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn.AnalyzedText;
import org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;

public class FuzzyTerm
extends IntervalFunction {
    private final String term;
    private final int maxEdits;
    private final Integer maxExpansions;

    public FuzzyTerm(String term, Integer maxEdits, Integer maxExpansions) {
        this.term = term;
        this.maxEdits = maxEdits == null ? 2 : maxEdits;
        this.maxExpansions = maxExpansions == null ? 128 : maxExpansions;
    }

    @Override
    public IntervalsSource toIntervalSource(String field2, Analyzer analyzer) {
        return Intervals.fuzzyTerm(this.term, this.maxEdits, 0, true, this.maxExpansions);
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:fuzzyTerm(%s %d%s)", AnalyzedText.requiresQuotes(this.term) ? "\"" + this.term + "\"" : this.term, this.maxEdits, this.maxExpansions);
    }
}

