/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.sandbox.search.AggregatedQueryLeafProfilerResult;
import org.apache.lucene.sandbox.search.QueryLeafProfilerBreakdown;
import org.apache.lucene.sandbox.search.QueryProfilerTimer;
import org.apache.lucene.sandbox.search.QueryProfilerTimingType;

class QueryLeafProfilerThreadAggregator {
    private final ConcurrentMap<Thread, QueryLeafProfilerBreakdown> queryThreadBreakdowns;
    private long queryStartTime = Long.MAX_VALUE;
    private long queryTotalTime = 0L;

    public QueryLeafProfilerThreadAggregator() {
        this.queryThreadBreakdowns = new ConcurrentHashMap<Thread, QueryLeafProfilerBreakdown>();
    }

    public long getQueryStartTime() {
        return this.queryStartTime;
    }

    public long getQueryTotalTime() {
        return this.queryTotalTime;
    }

    private QueryLeafProfilerBreakdown getQueryThreadProfilerBreakdown() {
        Thread currentThread = Thread.currentThread();
        QueryLeafProfilerBreakdown profilerBreakdown = (QueryLeafProfilerBreakdown)this.queryThreadBreakdowns.get(currentThread);
        if (profilerBreakdown != null) {
            return profilerBreakdown;
        }
        return this.queryThreadBreakdowns.computeIfAbsent(currentThread, unused2 -> new QueryLeafProfilerBreakdown());
    }

    public QueryProfilerTimer getTimer(QueryProfilerTimingType timingType) {
        assert (timingType.isLeafLevel());
        return this.getQueryThreadProfilerBreakdown().getTimer(timingType);
    }

    public List<AggregatedQueryLeafProfilerResult> getAggregatedQueryLeafProfilerResults() {
        ArrayList<AggregatedQueryLeafProfilerResult> profilerResults = new ArrayList<AggregatedQueryLeafProfilerResult>();
        for (Thread thread : this.queryThreadBreakdowns.keySet()) {
            AggregatedQueryLeafProfilerResult aggregatedQueryLeafProfilerResult = ((QueryLeafProfilerBreakdown)this.queryThreadBreakdowns.get(thread)).getLeafProfilerResult(thread);
            this.queryStartTime = Math.min(this.queryStartTime, aggregatedQueryLeafProfilerResult.getStartTime());
            this.queryTotalTime += aggregatedQueryLeafProfilerResult.getTotalTime();
            profilerResults.add(aggregatedQueryLeafProfilerResult);
        }
        return profilerResults;
    }
}

