/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import java.util.function.DoubleToLongFunction;
import java.util.function.LongToDoubleFunction;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.ByteVectorSimilarityValuesSource;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.FloatVectorSimilarityValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SegmentCacheable;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.comparators.DoubleComparator;
import org.apache.lucene.util.NumericUtils;

public abstract class DoubleValuesSource
implements SegmentCacheable {
    public static final DoubleValuesSource SCORES = new DoubleValuesSource(){

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            assert (scores != null);
            return scores;
        }

        @Override
        public boolean needsScores() {
            return true;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        @Override
        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) {
            return scoreExplanation;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public String toString() {
            return "scores";
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher searcher) {
            return this;
        }
    };

    public abstract DoubleValues getValues(LeafReaderContext var1, DoubleValues var2) throws IOException;

    public abstract boolean needsScores();

    public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
        DoubleValues dv = this.getValues(ctx, DoubleValuesSource.constant(scoreExplanation.getValue().doubleValue()).getValues(ctx, null));
        if (dv.advanceExact(docId)) {
            return Explanation.match((Number)dv.doubleValue(), this.toString(), new Explanation[0]);
        }
        return Explanation.noMatch(this.toString(), new Explanation[0]);
    }

    public abstract DoubleValuesSource rewrite(IndexSearcher var1) throws IOException;

    public SortField getSortField(boolean reverse) {
        return new DoubleValuesSortField(this, reverse);
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public final LongValuesSource toLongValuesSource() {
        return new LongDoubleValuesSource(this);
    }

    public final LongValuesSource toSortableLongDoubleValuesSource() {
        return new SortableLongDoubleValuesSource(this);
    }

    public static DoubleValues similarityToQueryVector(LeafReaderContext ctx, byte[] queryVector, String vectorField) throws IOException {
        return new ByteVectorSimilarityValuesSource(queryVector, vectorField).getValues(ctx, null);
    }

    public static DoubleValues similarityToQueryVector(LeafReaderContext ctx, float[] queryVector, String vectorField) throws IOException {
        return new FloatVectorSimilarityValuesSource(queryVector, vectorField).getValues(ctx, null);
    }

    public static DoubleValuesSource fromField(String field2, LongToDoubleFunction decoder) {
        return new FieldValuesSource(field2, decoder);
    }

    public static DoubleValuesSource fromDoubleField(String field2) {
        return DoubleValuesSource.fromField(field2, Double::longBitsToDouble);
    }

    public static DoubleValuesSource fromFloatField(String field2) {
        return DoubleValuesSource.fromField(field2, v -> Float.intBitsToFloat((int)v));
    }

    public static DoubleValuesSource fromLongField(String field2) {
        return DoubleValuesSource.fromField(field2, v -> v);
    }

    public static DoubleValuesSource fromIntField(String field2) {
        return DoubleValuesSource.fromLongField(field2);
    }

    public static DoubleValuesSource constant(double value) {
        return new ConstantValuesSource(value);
    }

    public static DoubleValues fromScorer(final Scorable scorer) {
        return new DoubleValues(){

            @Override
            public double doubleValue() throws IOException {
                return scorer.score();
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return true;
            }
        };
    }

    private static NumericDocValues asNumericDocValues(final DoubleValuesHolder in, final DoubleToLongFunction converter) {
        return new NumericDocValues(){

            @Override
            public long longValue() throws IOException {
                return converter.applyAsLong(in.values.doubleValue());
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return in.values.advanceExact(target);
            }

            @Override
            public int docID() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int nextDoc() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int advance(int target) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long cost() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static DoubleValuesSource fromQuery(Query query) {
        return new QueryDoubleValuesSource(query);
    }

    private static class DoubleValuesSortField
    extends SortField {
        final DoubleValuesSource producer;

        DoubleValuesSortField(DoubleValuesSource producer, boolean reverse) {
            super(producer.toString(), new DoubleValuesComparatorSource(producer), reverse);
            this.producer = producer;
        }

        @Override
        public void setMissingValue(Object missingValue) {
            if (missingValue instanceof Number) {
                this.missingValue = missingValue;
                ((DoubleValuesComparatorSource)this.getComparatorSource()).setMissingValue(((Number)missingValue).doubleValue());
            } else {
                super.setMissingValue(missingValue);
            }
        }

        @Override
        public boolean needsScores() {
            return this.producer.needsScores();
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder("<");
            buffer.append(this.getField()).append(">");
            if (this.reverse) {
                buffer.append("!");
            }
            return buffer.toString();
        }

        @Override
        public SortField rewrite(IndexSearcher searcher) throws IOException {
            DoubleValuesSource rewrittenSource = this.producer.rewrite(searcher);
            if (rewrittenSource == this.producer) {
                return this;
            }
            DoubleValuesSortField rewritten = new DoubleValuesSortField(rewrittenSource, this.reverse);
            if (this.missingValue != null) {
                rewritten.setMissingValue(this.missingValue);
            }
            return rewritten;
        }
    }

    private static class LongDoubleValuesSource
    extends LongValuesSource {
        private final DoubleValuesSource inner;

        private LongDoubleValuesSource(DoubleValuesSource inner) {
            this.inner = inner;
        }

        @Override
        public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            final DoubleValues in = this.inner.getValues(ctx, scores);
            return new LongValues(this){

                @Override
                public long longValue() throws IOException {
                    return (long)in.doubleValue();
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return in.advanceExact(doc);
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.inner.isCacheable(ctx);
        }

        @Override
        public boolean needsScores() {
            return this.inner.needsScores();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongDoubleValuesSource that = (LongDoubleValuesSource)o;
            return Objects.equals(this.inner, that.inner);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.inner);
        }

        @Override
        public String toString() {
            return "long(" + this.inner.toString() + ")";
        }

        @Override
        public LongValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this.inner.rewrite(searcher).toLongValuesSource();
        }
    }

    private static class SortableLongDoubleValuesSource
    extends LongValuesSource {
        private final DoubleValuesSource inner;

        private SortableLongDoubleValuesSource(DoubleValuesSource inner) {
            this.inner = Objects.requireNonNull(inner);
        }

        @Override
        public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            final DoubleValues in = this.inner.getValues(ctx, scores);
            return new LongValues(this){

                @Override
                public long longValue() throws IOException {
                    return NumericUtils.doubleToSortableLong(in.doubleValue());
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return in.advanceExact(doc);
                }
            };
        }

        @Override
        public boolean needsScores() {
            return this.inner.needsScores();
        }

        @Override
        public int hashCode() {
            return this.inner.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortableLongDoubleValuesSource that = (SortableLongDoubleValuesSource)o;
            return Objects.equals(this.inner, that.inner);
        }

        @Override
        public String toString() {
            return "sortableLong(" + this.inner.toString() + ")";
        }

        @Override
        public LongValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this.inner.rewrite(searcher).toLongValuesSource();
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }

    private static class FieldValuesSource
    extends DoubleValuesSource {
        final String field;
        final LongToDoubleFunction decoder;

        private FieldValuesSource(String field2, LongToDoubleFunction decoder) {
            this.field = field2;
            this.decoder = decoder;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldValuesSource that = (FieldValuesSource)o;
            return Objects.equals(this.field, that.field) && Objects.equals(this.decoder, that.decoder);
        }

        @Override
        public String toString() {
            return "double(" + this.field + ")";
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.field, this.decoder);
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            final NumericDocValues values = DocValues.getNumeric(ctx.reader(), this.field);
            return new DoubleValues(){

                @Override
                public double doubleValue() throws IOException {
                    return decoder.applyAsDouble(values.longValue());
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    return values.advanceExact(target);
                }
            };
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return DocValues.isCacheable(ctx, this.field);
        }

        @Override
        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
            DoubleValues values = this.getValues(ctx, null);
            if (values.advanceExact(docId)) {
                return Explanation.match((Number)values.doubleValue(), this.toString(), new Explanation[0]);
            }
            return Explanation.noMatch(this.toString(), new Explanation[0]);
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this;
        }
    }

    private static class ConstantValuesSource
    extends DoubleValuesSource {
        private final DoubleValues doubleValues;
        private final double value;

        private ConstantValuesSource(final double value) {
            this.value = value;
            this.doubleValues = new DoubleValues(this){

                @Override
                public double doubleValue() {
                    return value;
                }

                @Override
                public boolean advanceExact(int doc) {
                    return true;
                }
            };
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher searcher) {
            return this;
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            return this.doubleValues;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }

        @Override
        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) {
            return Explanation.match((Number)this.value, "constant(" + this.value + ")", new Explanation[0]);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstantValuesSource that = (ConstantValuesSource)o;
            return Double.compare(that.value, this.value) == 0;
        }

        @Override
        public String toString() {
            return "constant(" + this.value + ")";
        }
    }

    private static class DoubleValuesHolder {
        DoubleValues values;

        private DoubleValuesHolder() {
        }
    }

    private static class QueryDoubleValuesSource
    extends DoubleValuesSource {
        private final Query query;

        private QueryDoubleValuesSource(Query query) {
            this.query = query;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryDoubleValuesSource that = (QueryDoubleValuesSource)o;
            return Objects.equals(this.query, that.query);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.query);
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            throw new UnsupportedOperationException("This DoubleValuesSource must be rewritten");
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return new WeightDoubleValuesSource(searcher.rewrite(this.query).createWeight(searcher, ScoreMode.COMPLETE, 1.0f));
        }

        @Override
        public String toString() {
            return "score(" + this.query.toString() + ")";
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }

    private static class WeightDoubleValuesSource
    extends DoubleValuesSource {
        private final Weight weight;

        private WeightDoubleValuesSource(Weight weight) {
            this.weight = weight;
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            final Scorer scorer = this.weight.scorer(ctx);
            if (scorer == null) {
                return DoubleValues.EMPTY;
            }
            return new DoubleValues(this){
                private final TwoPhaseIterator tpi;
                private final DocIdSetIterator disi;
                private Boolean tpiMatch;
                {
                    this.tpi = scorer.twoPhaseIterator();
                    this.disi = this.tpi == null ? scorer.iterator() : this.tpi.approximation();
                    this.tpiMatch = null;
                }

                @Override
                public double doubleValue() throws IOException {
                    return scorer.score();
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    if (this.disi.docID() < doc) {
                        this.disi.advance(doc);
                        this.tpiMatch = null;
                    }
                    if (this.disi.docID() == doc) {
                        if (this.tpi == null) {
                            return true;
                        }
                        if (this.tpiMatch == null) {
                            this.tpiMatch = this.tpi.matches();
                        }
                        return this.tpiMatch;
                    }
                    return false;
                }
            };
        }

        @Override
        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
            return this.weight.explain(ctx, docId);
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeightDoubleValuesSource that = (WeightDoubleValuesSource)o;
            return Objects.equals(this.weight, that.weight);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.weight);
        }

        @Override
        public String toString() {
            return "score(" + this.weight.parentQuery.toString() + ")";
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }

    private static class DoubleValuesComparatorSource
    extends FieldComparatorSource {
        private final DoubleValuesSource producer;
        private double missingValue;

        DoubleValuesComparatorSource(DoubleValuesSource producer) {
            this.producer = producer;
            this.missingValue = 0.0;
        }

        void setMissingValue(double missingValue) {
            this.missingValue = missingValue;
        }

        public FieldComparator<Double> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
            return new DoubleComparator(numHits, fieldname, this.missingValue, reversed, Pruning.NONE){

                @Override
                public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                    final DoubleValuesHolder holder = new DoubleValuesHolder();
                    return new DoubleComparator.DoubleLeafComparator(context){
                        LeafReaderContext ctx;

                        @Override
                        protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field2) {
                            this.ctx = context;
                            return DoubleValuesSource.asNumericDocValues(holder, Double::doubleToLongBits);
                        }

                        @Override
                        public void setScorer(Scorable scorer) throws IOException {
                            holder.values = producer.getValues(this.ctx, DoubleValuesSource.fromScorer(scorer));
                            super.setScorer(scorer);
                        }
                    };
                }
            };
        }
    }
}

